/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.ArrayList;

public abstract class TextUtils {
    private TextUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String Pattern_quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String[] splitLines(CharSequence content) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split();
    }

    public static int countLines(CharSequence content) {
        return new LineSplitter(content).countLines();
    }

    public static CharSequence selectHeadLines(CharSequence content, int lines) {
        return new LineSplitter(content).selectHeadLines(lines);
    }

    private static class LineSplitter {
        private final CharSequence content;
        private final int contentEnd;
        private int contentPos;

        public LineSplitter(CharSequence content) {
            this.content = content;
            this.contentEnd = content.length();
        }

        public CharSequence selectHeadLines(int lines) {
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                --lines;
            }
            return this.content.subSequence(0, this.contentPos);
        }

        public String[] split() {
            ArrayList<String> result = new ArrayList<String>();
            this.contentPos = 0;
            while (this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.subSequence(begin, end).toString());
            }
            return result.toArray(new String[result.size()]);
        }

        public int countLines() {
            this.contentPos = 0;
            int count = 0;
            while (this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                ++count;
            }
            return count;
        }

        private int findEndOfLine() {
            while (this.contentPos < this.contentEnd) {
                if (this.content.charAt(this.contentPos) == '\r') {
                    int endLine = this.contentPos++;
                    if (this.contentPos < this.contentEnd && this.content.charAt(this.contentPos) == '\n') {
                        ++this.contentPos;
                    }
                    return endLine;
                }
                if (this.content.charAt(this.contentPos) == '\n') {
                    int endLine = this.contentPos++;
                    return endLine;
                }
                ++this.contentPos;
            }
            return this.contentPos;
        }
    }
}

