/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.internal.core.ValidatorManager;
import org.eclipse.dltk.validators.internal.core.ValidatorMessages;
import org.eclipse.dltk.validators.internal.core.ValidatorsCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorDefinitionsContainer {
    private Map fValidatorTypeToValidatorMap = new HashMap(10);
    private List fValidatorList = new ArrayList(10);

    public void addValidator(IValidator validator) {
        if (!this.fValidatorList.contains(validator)) {
            IValidatorType InterpreterInstallType = validator.getValidatorType();
            ArrayList<IValidator> validatorList = (ArrayList<IValidator>)this.fValidatorTypeToValidatorMap.get(InterpreterInstallType);
            if (validatorList == null) {
                validatorList = new ArrayList<IValidator>(3);
                this.fValidatorTypeToValidatorMap.put(InterpreterInstallType, validatorList);
            }
            validatorList.add(validator);
            this.fValidatorList.add(validator);
        }
    }

    public void addValidatorList(List validatorList) {
        Iterator iterator = validatorList.iterator();
        while (iterator.hasNext()) {
            IValidator validator = (IValidator)iterator.next();
            this.addValidator(validator);
        }
    }

    public Map getValidateTypeToValidatorsMap() {
        return this.fValidatorTypeToValidatorMap;
    }

    public List getValidatorList() {
        return this.fValidatorList;
    }

    public List getValidatorList(String nature) {
        ArrayList<IValidator> res = new ArrayList<IValidator>(this.fValidatorList.size());
        Iterator iter = this.fValidatorList.iterator();
        while (iter.hasNext()) {
            IValidator validator = (IValidator)iter.next();
            String sharp = "#";
            String nature2 = validator.getValidatorType().getNature();
            if (!nature2.equals(nature) && !nature2.equals(sharp)) continue;
            res.add(validator);
        }
        return res;
    }

    public List getValidatorsList() {
        List validators = this.getValidatorList();
        ArrayList resultList = new ArrayList(validators.size());
        resultList.addAll(validators);
        return resultList;
    }

    public List getValidatorsList(String nature) {
        List Interpreters = this.getValidatorList(nature);
        ArrayList resultList = new ArrayList(Interpreters.size());
        resultList.addAll(Interpreters);
        return resultList;
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = ValidatorsCore.getDocument();
        Element config = doc.createElement("validatorSettings");
        doc.appendChild(config);
        Set validatorTypeSet = this.getValidateTypeToValidatorsMap().keySet();
        Iterator keyIterator = validatorTypeSet.iterator();
        while (keyIterator.hasNext()) {
            IValidatorType validatorType = (IValidatorType)keyIterator.next();
            if (!validatorType.isConfigurable()) continue;
            Element valiatorTypeElement = this.validatorTypeAsElement(doc, validatorType);
            config.appendChild(valiatorTypeElement);
        }
        return ValidatorsCore.serializeDocument(doc);
    }

    private Element validatorTypeAsElement(Document doc, IValidatorType validatorType) {
        Element element = doc.createElement("validatorType");
        element.setAttribute("id", validatorType.getID());
        List validatorList = (List)this.getValidateTypeToValidatorsMap().get(validatorType);
        Iterator validatorIterator = validatorList.iterator();
        while (validatorIterator.hasNext()) {
            IValidator validator = (IValidator)validatorIterator.next();
            Element validatorElement = this.validatorAsElement(doc, validator);
            element.appendChild(validatorElement);
        }
        return element;
    }

    private Element validatorAsElement(Document doc, IValidator validator) {
        Element element = doc.createElement("validator");
        element.setAttribute("id", validator.getID());
        validator.storeTo(doc, element);
        return element;
    }

    public static ValidatorDefinitionsContainer parseXMLIntoContainer(Reader input) throws IOException {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        ValidatorDefinitionsContainer.parseXMLIntoContainer(new InputSource(input), container);
        return container;
    }

    public static void parseXMLIntoContainer(InputSource input, ValidatorDefinitionsContainer container) throws IOException {
        Element config = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(input).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        if (!config.getNodeName().equalsIgnoreCase("validatorSettings")) {
            throw new IOException(ValidatorMessages.ValidatorRuntime_badFormat);
        }
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element validatorTypeElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (validatorTypeElement = (Element)node).getNodeName().equalsIgnoreCase("validatorType")) {
                ValidatorDefinitionsContainer.populateValidatorTypes(validatorTypeElement, container);
            }
            ++i;
        }
    }

    private static void populateValidatorTypes(Element validatorTypeElement, ValidatorDefinitionsContainer container) {
        String id = validatorTypeElement.getAttribute("id");
        IValidatorType validatorType = ValidatorManager.getValidatorTypeFromID(id);
        if (validatorType != null) {
            NodeList validatorNodeList = validatorTypeElement.getChildNodes();
            int i = 0;
            while (i < validatorNodeList.getLength()) {
                Element InterpreterElement;
                Node InterpreterNode = validatorNodeList.item(i);
                short type = InterpreterNode.getNodeType();
                if (type == 1 && (InterpreterElement = (Element)InterpreterNode).getNodeName().equalsIgnoreCase("validator")) {
                    ValidatorDefinitionsContainer.populateValidatorForType(validatorType, InterpreterElement, container);
                }
                ++i;
            }
        } else if (DLTKCore.DEBUG) {
            System.err.println("Interpreter type element with unknown id.");
        }
    }

    private static void populateValidatorForType(IValidatorType interpreterType, Element validatorElement, ValidatorDefinitionsContainer container) {
        String id = validatorElement.getAttribute("id");
        if (id != null) {
            try {
                IValidator validator = interpreterType.createValidatorFrom(id, validatorElement);
                container.addValidator(validator);
            }
            catch (IOException iOException) {
                Status errorStatus = new Status(0, "org.eclipse.dltk.validators.core", 0, ValidatorMessages.ValidatorDefinitionsContainer_failedToLoadValidatorFromXml, null);
                DLTKCore.getDefault().getLog().log((IStatus)errorStatus);
            }
        } else if (DLTKCore.DEBUG) {
            System.err.println("id attribute missing from Interpreter element specification.");
        }
    }

    public void removeValidator(IValidator Interpreter) {
        this.fValidatorList.remove(Interpreter);
        List list = (List)this.fValidatorTypeToValidatorMap.get(Interpreter.getValidatorType());
        if (list != null) {
            list.remove(Interpreter);
        }
    }
}

