/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.launching;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;

public class RubyLaunchConfigurationDelegate
extends AbstractScriptLaunchConfigurationDelegate {
    public String getLanguageId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        InterpreterConfig config = super.createInterpreterConfig(configuration, launch);
        if (config != null) {
            this.addEncodingInterpreterArg(config, configuration);
            this.addIncludePathInterpreterArg(config, configuration);
            this.addStreamSync(config, configuration, launch);
        }
        return config;
    }

    protected String getCharset(ILaunchConfiguration configuration) throws CoreException {
        IProject project = RubyLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration).getProject();
        IResource resource = project.findMember(RubyLaunchConfigurationDelegate.getMainScriptName((ILaunchConfiguration)configuration));
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return file.getCharset();
        }
        return null;
    }

    protected String getCharsetInterpreterFlag(String charset) {
        if (charset.equals("UTF-8")) {
            return "-KU";
        }
        if (charset.equals("EUC")) {
            return "-KE";
        }
        if (charset.equals("SJIS")) {
            return "-KS";
        }
        return "-KA";
    }

    protected void addEncodingInterpreterArg(InterpreterConfig config, ILaunchConfiguration configuration) throws CoreException {
        String charset;
        if (!config.hasMatchedInterpreterArg("-K.*") && (charset = this.getCharset(configuration)) != null) {
            config.addInterpreterArg(this.getCharsetInterpreterFlag(charset));
        }
    }

    protected void addIncludePathInterpreterArg(InterpreterConfig config, ILaunchConfiguration configuration) throws CoreException {
        IPath[] paths = this.createBuildPath(configuration);
        IEnvironment env = config.getEnvironment();
        char separator = env.getPathsSeparatorChar();
        StringBuffer sb = new StringBuffer();
        if (paths.length > 0) {
            sb.append("-I");
            sb.append(env.convertPathToString(paths[0]));
            int i = 1;
            while (i < paths.length) {
                sb.append(separator);
                sb.append(env.convertPathToString(paths[i]));
                ++i;
            }
        }
        config.addInterpreterArg(sb.toString());
    }

    protected void addStreamSync(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) {
        try {
            IDeployment deployment = config.getExecutionEnvironment().createDeployment();
            IPath path = deployment.add(RubyLaunchingPlugin.getDefault().getBundle(), "scripts/sync.rb");
            config.addInterpreterArg("-r");
            config.addInterpreterArg(deployment.getFile(path).toString());
        }
        catch (IOException e) {
            RubyLaunchingPlugin.log(e);
        }
    }
}

