/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ruby.internal.ui.text.ISymbols;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;

public abstract class ScriptHeuristicScanner
implements ISymbols {
    public static final int NOT_FOUND = -1;
    public static final int UNBOUND = -2;
    private static final char LBRACE = '{';
    private static final char RBRACE = '}';
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char SEMICOLON = ';';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char QUESTIONMARK = '?';
    private static final char EQUAL = '=';
    private static final char LANGLE = '<';
    private static final char RANGLE = '>';
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char STAR = '*';
    private final StopCondition fNonWSDefaultPart = new NonWhitespaceDefaultPartition();
    private static final StopCondition fNonWS = new NonWhitespace();
    private final StopCondition fNonIdentifier = new NonIdentifierPartDefaultPartition();
    private final IDocument fDocument;
    private final String fPartitioning;
    private final String fPartition;
    private char fChar;
    private int fPos;
    private ITypedRegion fCachedPartition = new TypedRegion(-1, 0, "__no_partition_at_all");

    protected ScriptHeuristicScanner(IDocument document, String partitioning, String partition) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((partitioning != null ? 1 : 0) != 0);
        Assert.isLegal((partition != null ? 1 : 0) != 0);
        this.fDocument = document;
        this.fPartitioning = partitioning;
        this.fPartition = partition;
    }

    public int getPosition() {
        return this.fPos;
    }

    protected void setPosition(int pos) {
        this.fPos = pos;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    protected ITypedRegion getPartition(int position) {
        if (!this.contains((IRegion)this.fCachedPartition, position)) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0);
            Assert.isTrue((position <= this.fDocument.getLength() ? 1 : 0) != 0);
            try {
                this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)position, (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.fCachedPartition = new TypedRegion(position, 0, "__no_partition_at_all");
            }
        }
        return this.fCachedPartition;
    }

    private boolean contains(IRegion region, int position) {
        int offset = region.getOffset();
        return offset <= position && position < offset + region.getLength();
    }

    public boolean isDefaultPartition(int position) {
        return this.fPartition.equals(this.getPartition(position).getType());
    }

    public int scanForward(int start, int bound, StopCondition condition) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        if (bound == -2) {
            bound = this.fDocument.getLength();
        }
        Assert.isLegal((bound <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start;
            while (this.fPos < bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, true)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, true);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        Assert.isLegal((bound >= -1 ? 1 : 0) != 0);
        Assert.isLegal((start <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            this.fPos = start - 1;
            while (this.fPos >= bound) {
                this.fChar = this.fDocument.getChar(this.fPos);
                if (condition.stop(this.fChar, this.fPos, false)) {
                    return this.fPos;
                }
                this.fPos = condition.nextPosition(this.fPos, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    public int findNonWhitespaceForward(int position, int bound) {
        return this.scanForward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceForwardInAnyPartition(int position, int bound) {
        return this.scanForward(position, bound, fNonWS);
    }

    public int findNonWhitespaceBackward(int position, int bound) {
        return this.scanBackward(position, bound, this.fNonWSDefaultPart);
    }

    public int findNonWhitespaceBackwardInAnyPartition(int position, int bound) {
        return this.scanBackward(position, bound, fNonWS);
    }

    protected int getGenericToken(char ch) {
        switch (ch) {
            case '{': {
                return 1;
            }
            case '}': {
                return 2;
            }
            case '[': {
                return 3;
            }
            case ']': {
                return 4;
            }
            case '(': {
                return 5;
            }
            case ')': {
                return 6;
            }
            case ';': {
                return 7;
            }
            case ':': {
                return 8;
            }
            case ',': {
                return 9;
            }
            case '?': {
                return 10;
            }
            case '=': {
                return 11;
            }
            case '<': {
                return 12;
            }
            case '>': {
                return 13;
            }
            case '\\': {
                return 16;
            }
            case '/': {
                return 17;
            }
            case '+': {
                return 18;
            }
            case '-': {
                return 19;
            }
            case '*': {
                return 20;
            }
        }
        return 14;
    }

    public int nextToken(int start, int bound) {
        int pos = this.scanForward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        ++this.fPos;
        int token = this.getGenericToken(this.fChar);
        if (token != 14) {
            return token;
        }
        if (this.isValidIdentifierPart(this.fChar)) {
            int from = pos;
            int to = (pos = this.findNonIdentifierForward(pos, bound)) == -1 ? (bound == -2 ? this.fDocument.getLength() : bound) : pos;
            return this.getToken(from, to);
        }
        return 14;
    }

    public int previousToken(int start, int bound) {
        int pos = this.scanBackward(start, bound, this.fNonWSDefaultPart);
        if (pos == -1) {
            return -1;
        }
        --this.fPos;
        int token = this.getGenericToken(this.fChar);
        if (token != 14) {
            return token;
        }
        if (this.isValidIdentifierPart(this.fChar)) {
            int to = pos + 1;
            int from = (pos = this.findNonIdentifierBackward(pos, bound)) == -1 ? (bound == -2 ? 0 : bound) : pos + 1;
            return this.getToken(from, to);
        }
        return 14;
    }

    private int getToken(int from, int to) {
        String identOrKeyword;
        try {
            identOrKeyword = this.fDocument.get(from, to - from);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        return this.getToken(from, identOrKeyword);
    }

    public int findNonIdentifierForward(int offset, int bound) {
        return this.scanForward(offset, bound, this.fNonIdentifier);
    }

    public int findNonIdentifierBackward(int offset, int bound) {
        return this.scanBackward(offset, bound, this.fNonIdentifier);
    }

    public int findPrecedingNotEmptyLine(int offset) {
        try {
            int notEmptyPositioin = this.findNonWhitespaceBackward(offset, -2);
            if (notEmptyPositioin != -1) {
                return this.fDocument.getLineInformationOfOffset(notEmptyPositioin).getOffset();
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return 0;
    }

    public int findClosingPeer(int start, char openingPeer, char closingPeer) {
        return this.findClosingPeer(start, -2, openingPeer, closingPeer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findClosingPeer(int start, int bound, char openingPeer, char closingPeer) {
        Assert.isLegal((start >= 0 ? 1 : 0) != 0);
        try {
            CharacterMatch match = new CharacterMatch(new char[]{openingPeer, closingPeer});
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, bound, match)) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == openingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int findOpeningPeer(int start, char openingPeer, char closingPeer) {
        return this.findOpeningPeer(start, -2, openingPeer, closingPeer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOpeningPeer(int start, int bound, char openingPeer, char closingPeer) {
        Assert.isLegal((start <= this.fDocument.getLength() ? 1 : 0) != 0);
        try {
            CharacterMatch match = new CharacterMatch(new char[]{openingPeer, closingPeer});
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, bound, match)) == -1) {
                    return -1;
                }
                if (this.fDocument.getChar(start) == closingPeer) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion findWordAt(int offset) {
        try {
            int length;
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int start = this.findNonIdentifierBackward(offset, line.getOffset());
            int end = this.findNonIdentifierForward(offset, line.getOffset() + line.getLength());
            start = start == -1 ? line.getOffset() : ++start;
            if (end == -1) {
                end = line.getOffset() + line.getLength();
            }
            if ((length = end - start) > 0) {
                return new Region(start, length);
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    public abstract int getToken(int var1, String var2);

    protected boolean isValidIdentifierPart(char symbol) {
        return Character.isJavaIdentifierPart(symbol);
    }

    protected final class CharacterMatch
    extends StopCondition {
        private final char[] fChars;

        public CharacterMatch(char ch) {
            this(new char[]{ch});
        }

        public CharacterMatch(char[] chars) {
            Assert.isNotNull((Object)chars);
            Assert.isTrue((chars.length > 0 ? 1 : 0) != 0);
            this.fChars = chars;
            Arrays.sort(chars);
        }

        public boolean stop(char ch, int position, boolean forward) {
            return Arrays.binarySearch(this.fChars, ch) >= 0 && ScriptHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = ScriptHeuristicScanner.this.getPartition(position);
            if (ScriptHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    protected class NonIdentifierPart
    extends StopCondition {
        protected NonIdentifierPart() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !ScriptHeuristicScanner.this.isValidIdentifierPart(ch);
        }
    }

    protected final class NonIdentifierPartDefaultPartition
    extends NonIdentifierPart {
        protected NonIdentifierPartDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) || !ScriptHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = ScriptHeuristicScanner.this.getPartition(position);
            if (ScriptHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    protected static class NonWhitespace
    extends StopCondition {
        protected NonWhitespace() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return !Character.isWhitespace(ch);
        }
    }

    protected final class NonWhitespaceDefaultPartition
    extends NonWhitespace {
        protected NonWhitespaceDefaultPartition() {
        }

        public boolean stop(char ch, int position, boolean forward) {
            return super.stop(ch, position, true) && ScriptHeuristicScanner.this.isDefaultPartition(position);
        }

        public int nextPosition(int position, boolean forward) {
            ITypedRegion partition = ScriptHeuristicScanner.this.getPartition(position);
            if (ScriptHeuristicScanner.this.fPartition.equals(partition.getType())) {
                return super.nextPosition(position, forward);
            }
            if (forward) {
                int end = partition.getOffset() + partition.getLength();
                if (position < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (position > offset) {
                    return offset - 1;
                }
            }
            return super.nextPosition(position, forward);
        }
    }

    protected static abstract class StopCondition {
        protected StopCondition() {
        }

        public abstract boolean stop(char var1, int var2, boolean var3);

        public int nextPosition(int position, boolean forward) {
            return forward ? position + 1 : position - 1;
        }
    }
}

