/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.tclchecker.Messages;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMarker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblem;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class TclChecker {
    private static final String PATTERN_TXT = "pattern.txt";
    private static final String CHECKING = "checking:";
    private static final String SCANNING = "scanning:";
    private ISourceModule checkingModule;
    private IPreferenceStore store;
    static /* synthetic */ Class class$0;

    protected static IMarker reportErrorProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 2, 1);
    }

    protected static IMarker reportWarningProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 1, 1);
    }

    public TclChecker(IPreferenceStore store) {
        if (store == null) {
            throw new NullPointerException("store cannot be null");
        }
        this.store = store;
    }

    public boolean canCheck(IEnvironment environment) {
        return TclCheckerHelper.canExecuteTclChecker(this.store, environment);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check(List sourceModules, IProgressMonitor monitor, OutputStream consoleStream, IEnvironment environment) {
        block39: {
            block38: {
                if (!this.canCheck(environment)) {
                    throw new IllegalStateException(Messages.TclChecker_cannot_be_executed);
                }
                arguments = new ArrayList<String>();
                pathToSource = new HashMap<String, ISourceModule>();
                moduleToCodeModel = new HashMap<ISourceModule, TclParseUtil.CodeModel>();
                iterator = sourceModules.iterator();
                while (true) {
                    block37: {
                        if (!iterator.hasNext()) {
                            if (!arguments.isEmpty()) break;
                            if (monitor == null) return;
                            monitor.done();
                            return;
                        }
                        module = (ISourceModule)iterator.next();
                        try {
                            source = module.getSource();
                            if (source.length() == 0) continue;
                            codeModel = new TclParseUtil.CodeModel(source);
                            moduleToCodeModel.put(module, codeModel);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block37;
                            e.printStackTrace();
                        }
                    }
                    location = module.getResource().getLocation();
                    loc = null;
                    if (location == null) {
                        locationURI = module.getResource().getLocationURI();
                        loc = environment.getFile(locationURI).toString();
                    } else {
                        loc = location.toString();
                    }
                    pathToSource.put(loc, module);
                    arguments.add(loc);
                }
                console = consoleStream != null ? new PrintStream(consoleStream, true) : null;
                cmdLine = new ArrayList<String>();
                if (!TclCheckerHelper.passOriginalArguments(this.store, cmdLine, environment) && console != null) {
                    console.println(Messages.TclChecker_path_not_specified);
                }
                if ((v0 = TclChecker.class$0) == null) {
                    try {
                        v1 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
                    }
                    catch (ClassNotFoundException v2) {
                        throw new NoClassDefFoundError(v2.getMessage());
                    }
                    v0 = TclChecker.class$0 = v1;
                }
                if ((pattern = this.deployFileList(deployment = (execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)v0)).createDeployment(), arguments)) == null) {
                    return;
                }
                cmdLine.add("-@");
                cmdLine.add(deployment.getFile(pattern).toOSString());
                input = null;
                scanned = 0;
                checked = 0;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.TclChecker_executing, sourceModules.size() * 2 + 1);
                map = execEnvironment.getEnvironmentVariables(false);
                env = new String[map.size()];
                i = 0;
                iterator = map.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        ** try [egrp 2[TRYBLOCK] [5 : 552->1132)] { 
lbl67:
                        // 1 sources

                        break;
                    }
                    key = (String)iterator.next();
                    value = (String)map.get(key);
                    env[i] = String.valueOf(key) + "=" + value;
                    ++i;
                }
                {
                    try {
                        monitor.subTask(Messages.TclChecker_launching);
                        process = execEnvironment.exec(cmdLine.toArray(new String[cmdLine.size()]), null, env);
                        monitor.worked(1);
                        input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        model = null;
                        while (true) {
                            if ((line = input.readLine()) == null) break;
                            if (console != null) {
                                console.println(line);
                            }
                            problem = TclCheckerHelper.parseProblem(line);
                            if (monitor.isCanceled()) {
                                process.destroy();
lbl87:
                                // 2 sources

                                while (true) {
                                    var26_28 = null;
                                    break block38;
                                    break;
                                }
                            }
                            if (line.startsWith("scanning:")) {
                                fileName = line.substring("scanning:".length() + 1).trim();
                                fileName = Path.fromOSString((String)fileName).lastSegment();
                                monitor.subTask(NLS.bind((String)Messages.TclChecker_scanning, (Object)fileName, (Object)String.valueOf(sourceModules.size() - scanned)));
                                monitor.worked(1);
                                ++scanned;
                            }
                            if (line.startsWith("checking:")) {
                                fileName = line.substring("checking:".length() + 1).trim();
                                path = Path.fromOSString((String)fileName);
                                checkingFile = path.toString();
                                this.checkingModule = (ISourceModule)pathToSource.get(checkingFile);
                                if (this.checkingModule == null) {
                                    this.checkingModule = this.findSourceModule(pathToSource, path);
                                }
                                model = (TclParseUtil.CodeModel)moduleToCodeModel.get(this.checkingModule);
                                monitor.subTask(NLS.bind((String)Messages.TclChecker_checking, (Object)path.lastSegment(), (Object)String.valueOf(sourceModules.size() - checked)));
                                monitor.worked(1);
                                ++checked;
                            }
                            if (problem == null || this.checkingModule == null || model == null) continue;
                            desc = problem.getDescription();
                            bounds = model.getBounds(problem.getLineNumber() - 1);
                            res = this.checkingModule.getResource();
                            if (TclCheckerProblemDescription.isError(desc.getCategory())) {
                                TclChecker.reportErrorProblem(res, problem, bounds[0], bounds[1]);
                                continue;
                            }
                            if (!TclCheckerProblemDescription.isWarning(desc.getCategory())) continue;
                            TclChecker.reportWarningProblem(res, problem, bounds[0], bounds[1]);
                        }
                        errorMessage = new StringBuffer();
                        input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        do {
                            if ((line = input.readLine()) == null) {
                                if (errorMessage.length() > 0) {
                                    TclCheckerPlugin.log(4, String.valueOf(Messages.TclChecker_execution_error) + errorMessage.toString());
                                }
                                break block39;
                            }
                            if (console != null) {
                                console.println(line);
                            }
                            errorMessage.append(line).append('\n');
                        } while (!monitor.isCanceled());
                        process.destroy();
                        ** continue;
                    }
                    catch (Exception e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        break block39;
                    }
                }
lbl137:
                // 1 sources

                catch (Throwable var27_34) {
                    var26_29 = null;
                    monitor.done();
                    deployment.dispose();
                    if (input == null) throw var27_34;
                    try {
                        input.close();
                        throw var27_34;
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG == false) throw var27_34;
                        e.printStackTrace();
                    }
                    throw var27_34;
                }
            }
            monitor.done();
            deployment.dispose();
            if (input == null) return;
            ** try [egrp 4[TRYBLOCK] [8 : 1160->1168)] { 
lbl155:
            // 1 sources

            input.close();
            return;
lbl157:
            // 1 sources

            catch (IOException e) {
                if (DLTKCore.DEBUG == false) return;
                e.printStackTrace();
            }
            return;
        }
        var26_30 = null;
        monitor.done();
        deployment.dispose();
        if (input == null) return;
        try {}
        catch (IOException e) {
            if (DLTKCore.DEBUG == false) return;
            e.printStackTrace();
            return;
        }
        input.close();
    }

    private ISourceModule findSourceModule(Map pathToSource, IPath path) {
        String shortFileName = path.lastSegment();
        String fullPath = null;
        Iterator iterator = pathToSource.keySet().iterator();
        while (iterator.hasNext()) {
            String p = (String)iterator.next();
            if (!p.endsWith(shortFileName)) continue;
            if (fullPath != null) {
                return null;
            }
            fullPath = p;
        }
        if (fullPath != null) {
            return (ISourceModule)pathToSource.get(fullPath);
        }
        return null;
    }

    private IPath deployFileList(IDeployment deployment, List arguments) {
        ByteArrayOutputStream baros = new ByteArrayOutputStream();
        try {
            Iterator arg = arguments.iterator();
            while (arg.hasNext()) {
                String path = (String)arg.next();
                baros.write((String.valueOf(path) + "\n").getBytes());
            }
            baros.close();
        }
        catch (IOException iOException) {}
        try {
            return deployment.add((InputStream)new ByteArrayInputStream(baros.toByteArray()), PATTERN_TXT);
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                TclCheckerPlugin.log(4, Messages.TclChecker_filelist_deploy_failed, e);
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

