/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.util.ArrayList;
import java.util.Observer;
import java.util.WeakHashMap;
import org.eclipse.dltk.rhino.dbgp.BreakPoint;
import org.eclipse.dltk.rhino.dbgp.BreakPointManager;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugFrame;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugger;
import org.mozilla.javascript.Context;

public class DBGPStackManager {
    protected static WeakHashMap map = new WeakHashMap();
    private ArrayList stack = new ArrayList();
    private static boolean breakpointsThreadLocal;
    private boolean needSuspend;
    private DBGPDebugger observer;
    private BreakPointManager manager = null;
    private static BreakPointManager gmanager;
    private boolean suspendOnExit;
    private boolean suspendOnEntry;
    private boolean suspenOnChangeLine;
    static /* synthetic */ Class class$0;

    static {
        gmanager = null;
    }

    public BreakPointManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DBGPStackManager() {
        if (DBGPStackManager.isBreakpointsThreadLocal()) {
            this.manager = new BreakPointManager();
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.rhino.dbgp.DBGPStackManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (gmanager == null) {
                gmanager = new BreakPointManager();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.manager = gmanager;
            return;
        }
    }

    public static DBGPStackManager getManager(Context cx) {
        DBGPStackManager object = (DBGPStackManager)map.get(cx);
        if (object != null) {
            return object;
        }
        object = new DBGPStackManager();
        map.put(cx, object);
        return object;
    }

    public static void removeManager(Context cx) {
        map.remove(cx);
    }

    public void enter(DBGPDebugFrame debugFrame) {
        BreakPoint hit;
        this.stack.add(debugFrame);
        String sn = debugFrame.getWhere();
        if (sn != null && (hit = this.manager.hitEnter(sn)) != null) {
            this.checkBreakpoint(debugFrame, hit);
        }
        if (this.suspendOnEntry) {
            if (debugFrame.getWhere().equals("module")) {
                this.observer.update(null, this);
                this.waitForContinuation();
            } else {
                this.suspenOnChangeLine = true;
            }
        }
    }

    public void exit(DBGPDebugFrame debugFrame) {
        BreakPoint hit;
        String sn;
        if (this.needSuspend || this.suspendOnExit) {
            this.observer.update(null, this);
            this.waitForContinuation();
        }
        if ((sn = debugFrame.getWhere()) != null && (hit = this.manager.hitExit(sn)) != null) {
            this.checkBreakpoint(debugFrame, hit);
        }
        this.stack.remove(debugFrame);
    }

    public void changeLine(DBGPDebugFrame frame, int lineNumber) {
        if (this.suspenOnChangeLine) {
            this.suspenOnChangeLine = false;
            this.observer.update(null, this);
            this.waitForContinuation();
        }
        if (frame.isSuspend()) {
            this.needSuspend = true;
        }
        BreakPoint hit = this.manager.hit(frame.getSourceName(), lineNumber);
        this.checkBreakpoint(frame, hit);
    }

    private synchronized void waitForContinuation() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void continueExecution() {
        this.notify();
    }

    private void checkBreakpoint(DBGPDebugFrame frame, BreakPoint hit) {
        if (hit != null && hit.isEnabled()) {
            Object eval;
            this.needSuspend = hit.expression != null ? ((eval = frame.eval(hit.expression)) != null ? eval.equals(Boolean.TRUE) : false) : true;
        }
        if (this.needSuspend) {
            this.observer.update(null, this);
            this.waitForContinuation();
        }
    }

    public void exceptionThrown(Throwable ex) {
    }

    public void suspend() {
        this.needSuspend = true;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public DBGPDebugFrame getStackFrame(int parseInt) {
        int stackCounter = this.stack.size() - parseInt - 1;
        if (stackCounter >= 0) {
            return (DBGPDebugFrame)this.stack.get(stackCounter);
        }
        return null;
    }

    public int getLineNumber(String level) {
        return this.getStackFrame(0).getLineNumber();
    }

    public void registerBreakPoint(BreakPoint p) {
        this.manager.addBreakPoint(p);
    }

    public void setDebugger(DBGPDebugger debugger) {
        this.observer = debugger;
    }

    public synchronized void resume() {
        this.needSuspend = false;
        int a = 0;
        while (a < this.getStackDepth()) {
            this.getStackFrame(a).setSuspend(false);
            ++a;
        }
        this.continueExecution();
    }

    public synchronized void stepOver() {
        this.getStackFrame(0).setSuspend(true);
        if (this.getStackDepth() > 1) {
            this.getStackFrame(1).setSuspend(true);
        }
        this.needSuspend = false;
        this.continueExecution();
    }

    public synchronized void stepIn() {
        this.needSuspend = true;
        this.continueExecution();
    }

    public synchronized void stepOut() {
        this.getStackFrame(0).setSuspend(false);
        this.needSuspend = false;
        if (this.getStackDepth() > 1) {
            this.getStackFrame(1).setSuspend(true);
        }
        this.continueExecution();
    }

    public void waitForNotify() {
        this.waitForContinuation();
    }

    public void removeBreakpoint(String id) {
        this.manager.removeBreakPoint(id);
    }

    public void updateBreakpoint(String id, String newState, String newLine, String hitValue, String hitCondition, String condExpr) {
        this.manager.updateBreakpoint(id, newState, newLine, hitValue, hitCondition, condExpr);
    }

    public Observer getObserver() {
        return this.observer;
    }

    public BreakPoint getBreakpoint(String id) {
        return this.manager.getBreakpoint(id);
    }

    public void setSuspendOnExit(boolean parseBoolean) {
        this.suspendOnExit = parseBoolean;
    }

    public void setSuspendOnEntry(boolean parseBoolean) {
        this.suspendOnEntry = parseBoolean;
    }

    public static boolean isBreakpointsThreadLocal() {
        return breakpointsThreadLocal;
    }

    public static void setBreakpointsThreadLocal(boolean breakpointsThreadLocal) {
        DBGPStackManager.breakpointsThreadLocal = breakpointsThreadLocal;
    }
}

