/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;

public class CombinedOrReference
implements IReference,
SelfCompletingReference {
    private final List lstReadonly;
    private final List lstReferences = new ArrayList();
    private boolean recursiveCheck;

    public CombinedOrReference() {
        this.lstReadonly = new ArrayList();
    }

    private CombinedOrReference(List references, List readonly) {
        this();
        IReference element;
        int i = 0;
        while (i < readonly.size()) {
            element = (IReference)readonly.get(i);
            this.addReadonly(element);
            ++i;
        }
        i = 0;
        while (i < references.size()) {
            element = (IReference)references.get(i);
            this.addReference(element);
            ++i;
        }
    }

    public CombinedOrReference(IReference rm, IReference root) {
        this();
        this.addReadonly(rm);
        this.addReference(root);
    }

    public void addReference(IReference reference) {
        if (reference instanceof CombinedOrReference) {
            this.addCombinedReference(reference);
        } else if (!this.testContains(reference)) {
            this.lstReferences.add(reference);
        }
    }

    boolean testContains(IReference reference) {
        Object element;
        if (reference == this) {
            return true;
        }
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element.equals(reference)) {
                return true;
            }
            if (this.testTransparentRef(reference, element)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element.equals(reference)) {
                return true;
            }
            if (this.testTransparentRef(reference, element)) {
                return true;
            }
            ++i;
        }
        return this.testTransparentRef(this, reference);
    }

    private boolean testTransparentRef(IReference reference, Object element) {
        if (element instanceof TransparentRef) {
            CombinedOrReference cor;
            TransparentRef transparentRef = (TransparentRef)element;
            if (transparentRef.evaluateReference == reference) {
                return true;
            }
            if (transparentRef.evaluateReference instanceof CombinedOrReference && (cor = (CombinedOrReference)transparentRef.evaluateReference).testContains(this)) {
                return true;
            }
        }
        return false;
    }

    private void addCombinedReference(IReference reference) {
        CombinedOrReference cor = (CombinedOrReference)reference;
        int i = 0;
        while (i < cor.lstReferences.size()) {
            this.addReference((IReference)cor.lstReferences.get(i));
            ++i;
        }
        i = 0;
        while (i < cor.lstReadonly.size()) {
            this.addReadonly((IReference)cor.lstReadonly.get(i));
            ++i;
        }
    }

    public void addReadonly(IReference reference) {
        if (reference instanceof CombinedOrReference) {
            this.addCombinedReference(reference);
        } else if (!this.testContains(reference)) {
            this.lstReadonly.add(reference);
        }
    }

    public void addModelElements(Collection toAdd) {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            element.addModelElements(toAdd);
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            element.addModelElements(toAdd);
            ++i;
        }
    }

    public IReference getChild(String key, boolean resolveLocals) {
        ArrayList<IReference> alReferences = new ArrayList<IReference>();
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = (IReference)this.lstReferences.get(i);
            IReference child = element.getChild(key, resolveLocals);
            if (child != null && !alReferences.contains(child)) {
                alReferences.add(child);
            }
            ++i;
        }
        ArrayList<IReference> alReadonly = new ArrayList<IReference>();
        int i2 = 0;
        while (i2 < this.lstReadonly.size()) {
            IReference element = (IReference)this.lstReadonly.get(i2);
            IReference child = element.getChild(key, resolveLocals);
            if (child != null && !alReadonly.contains(child)) {
                alReadonly.add(child);
            }
            ++i2;
        }
        if (alReferences.size() == 0 && alReadonly.size() == 0) {
            return null;
        }
        if (alReferences.size() == 1 && alReadonly.size() == 0) {
            return (IReference)alReferences.get(0);
        }
        if (alReferences.size() == 0 && alReadonly.size() == 1) {
            return (IReference)alReadonly.get(0);
        }
        return new CombinedOrReference(alReferences, alReadonly).compressed();
    }

    private IReference compressed() {
        if (this.lstReferences.size() == 1 && this.lstReadonly.size() == 0) {
            return (IReference)this.lstReferences.get(0);
        }
        if (this.lstReferences.size() == 0 && this.lstReadonly.size() == 1) {
            return (IReference)this.lstReadonly.get(0);
        }
        return this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getChilds(boolean resolveLocals) {
        HashSet set = new HashSet();
        if (this.recursiveCheck) {
            return set;
        }
        try {
            IReference element;
            this.recursiveCheck = true;
            int i = 0;
            while (true) {
                if (i >= this.lstReferences.size()) {
                    i = 0;
                    break;
                }
                element = (IReference)this.lstReferences.get(i);
                set.addAll(element.getChilds(resolveLocals));
                ++i;
            }
            while (i < this.lstReadonly.size()) {
                element = (IReference)this.lstReadonly.get(i);
                set.addAll(element.getChilds(resolveLocals));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.recursiveCheck = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.recursiveCheck = false;
            return set;
        }
    }

    public String getName() {
        if (this.lstReferences.size() > 0) {
            return ((IReference)this.lstReferences.get(0)).getName();
        }
        if (this.lstReadonly.size() > 0) {
            return ((IReference)this.lstReadonly.get(0)).getName();
        }
        return null;
    }

    public IReference getPrototype(boolean resolveLocals) {
        ArrayList<IReference> alReferences = new ArrayList<IReference>();
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = (IReference)this.lstReferences.get(i);
            IReference prototype = element.getPrototype(resolveLocals);
            if (prototype != null && !alReferences.contains(prototype)) {
                alReferences.add(prototype);
            }
            ++i;
        }
        ArrayList<IReference> alReadonly = new ArrayList<IReference>();
        int i2 = 0;
        while (i2 < this.lstReadonly.size()) {
            IReference element = (IReference)this.lstReadonly.get(i2);
            IReference prototype = element.getPrototype(resolveLocals);
            if (prototype != null && !alReadonly.contains(prototype)) {
                alReadonly.add(prototype);
            }
            ++i2;
        }
        if (alReferences.size() == 0 && alReadonly.size() == 0) {
            return null;
        }
        if (alReferences.size() == 1 && alReadonly.size() == 0) {
            return (IReference)alReferences.get(0);
        }
        if (alReferences.size() == 0 && alReadonly.size() == 1) {
            return (IReference)alReadonly.get(0);
        }
        return new CombinedOrReference(alReferences, alReadonly).compressed();
    }

    public boolean isChildishReference() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element.isChildishReference()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element.isChildishReference()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFunctionRef() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element.isFunctionRef()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element.isFunctionRef()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLocal() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element.isLocal()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element.isLocal()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void recordDelete(String fieldId) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = (IReference)this.lstReferences.get(i);
            element.recordDelete(fieldId);
            ++i;
        }
    }

    public void setChild(String key, IReference ref) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = (IReference)this.lstReferences.get(i);
            element.setChild(key, ref);
            ++i;
        }
    }

    public void setLocal(boolean local) {
        IReference element;
        int i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            element.setLocal(local);
            ++i;
        }
        i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            element.setLocal(local);
            ++i;
        }
    }

    public void setLocationInformation(ModelElement mo, int position, int length) {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            element.setLocationInformation(mo, position, length);
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            element.setLocationInformation(mo, position, length);
            ++i;
        }
    }

    public void setPrototype(IReference ref) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = (IReference)this.lstReferences.get(i);
            element.setPrototype(ref);
            ++i;
        }
    }

    public boolean contains(IReference ref) {
        return this.lstReferences.contains(ref) || this.lstReadonly.contains(ref);
    }

    public URL getImageURL() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getImageURL() != null) {
                return ((SelfCompletingReference)element).getImageURL();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getImageURL() != null) {
                return ((SelfCompletingReference)element).getImageURL();
            }
            ++i;
        }
        return null;
    }

    public int getKind() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getKind() != 0) {
                return ((SelfCompletingReference)element).getKind();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getKind() != 0) {
                return ((SelfCompletingReference)element).getKind();
            }
            ++i;
        }
        return 0;
    }

    public char[][] getParameterNames() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getParameterNames() != null) {
                return ((SelfCompletingReference)element).getParameterNames();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getParameterNames() != null) {
                return ((SelfCompletingReference)element).getParameterNames();
            }
            ++i;
        }
        return null;
    }

    public String getReturnType() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getReturnType() != null) {
                return ((SelfCompletingReference)element).getReturnType();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getReturnType() != null) {
                return ((SelfCompletingReference)element).getReturnType();
            }
            ++i;
        }
        return null;
    }

    public String getProposalInfo() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = (IReference)this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getProposalInfo() != null) {
                return ((SelfCompletingReference)element).getProposalInfo();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = (IReference)this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getProposalInfo() != null) {
                return ((SelfCompletingReference)element).getProposalInfo();
            }
            ++i;
        }
        return null;
    }
}

