/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;

public final class ContextReference
implements IReference {
    private final HostCollection function;
    private final String key;
    private boolean local;
    private int position;
    private int length;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    ContextReference(HostCollection function, String key) {
        this.function = function;
        this.key = key;
    }

    public IReference getChild(String key, boolean resolveLocals) {
        return this.function.getReference(key);
    }

    public Set getChilds(boolean resolveLocals) {
        if (!resolveLocals) {
            return new HashSet();
        }
        Map references = this.function.getReferences();
        Collection values = references.values();
        HashSet hashSet = new HashSet(values);
        hashSet.remove(this);
        return hashSet;
    }

    public String getName() {
        return this.key;
    }

    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", resolveLocals);
    }

    public boolean isChildishReference() {
        return false;
    }

    public void recordDelete(String fieldId) {
    }

    public void setChild(String key, IReference ref) {
    }

    public void setPrototype(IReference ref) {
    }

    public void addModelElements(Collection toAdd) {
    }

    public void setLocationInformation(ModelElement mo, int position, int length) {
        this.position = position;
        this.length = length;
    }

    public boolean isFunctionRef() {
        return true;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }
}

