/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NativeStringReference;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;

public class NativeNumberReference
extends UnknownReference {
    private static UnknownReference toString = new NativeStringReference("toString").setFunctionRef();
    private static UnknownReference toLocaleString = new NativeStringReference("toLocaleString").setFunctionRef();
    private static UnknownReference toSource = new NativeStringReference("toSource").setFunctionRef();
    private static UnknownReference valueOf = new NativeStringReference("valueOf").setFunctionRef();
    private static UnknownReference toFixed = new NativeStringReference("toFixed").setFunctionRef();
    private static UnknownReference toExponential = new NativeStringReference("toExponential").setFunctionRef();
    private static UnknownReference toPrecision = new NativeStringReference("toPrecision").setFunctionRef();

    public NativeNumberReference(String paramOrVarName) {
        super(paramOrVarName, false);
    }

    protected void createChilds() {
        this.setChild("toString", toString);
        this.setChild("toLocaleString", toLocaleString);
        this.setChild("toSource", toSource);
        this.setChild("valueOf", valueOf);
        this.setChild("toFixed", toFixed);
        this.setChild("toExponential", toExponential);
        this.setChild("toPrecision", toPrecision);
    }

    public void setChild(String key, IReference ref) {
        if (ref instanceof UnknownReference) {
            UnknownReference ur = (UnknownReference)ref;
            String name = ref.getName();
            if (name.equals("toString")) {
                ur.setProposalInfo("Returns a String value for this Number.");
            } else if (name.equals("toSource")) {
                ur.setProposalInfo("The toSource() method represents the source code of an object.");
            } else if (name.equals("valueOf")) {
                ur.setProposalInfo("Returns the primitive value of a Number object.");
            } else if (name.equals("toExponential")) {
                ur.setProposalInfo("Converts the value of the object into an exponential notation.");
                ur.setParameterNames(new char[][]{"numberOfDecimals".toCharArray()});
            } else if (name.equals("toFixed")) {
                ur.setProposalInfo("Formats a number to the specified number of decimals.");
                ur.setParameterNames(new char[][]{"numberOfDecimals".toCharArray()});
            } else if (!name.equals("toLocaleString") && name.equals("toPrecision")) {
                ur.setProposalInfo("Converts a number into an exponential notation if it has more digits than specified.");
                ur.setParameterNames(new char[][]{"numberOfDigits".toCharArray()});
            }
        }
        super.setChild(key, ref);
    }
}

