/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.CorePrinter;

public class ExpressionList
extends Expression {
    private List fExpressions = new ArrayList();

    protected ExpressionList(int start, int end) {
        super(start, end);
    }

    public ExpressionList() {
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit(this)) {
            if (this.fExpressions != null) {
                for (Expression e : this.fExpressions) {
                    e.traverse(pVisitor);
                }
            }
            pVisitor.endvisit(this);
        }
    }

    public int getKind() {
        return 1064;
    }

    public void setExpresssions(List exs) {
        for (Object e : exs) {
            if (e instanceof Expression) {
                this.addExpression((Expression)e);
                continue;
            }
            if (!DLTKCore.DEBUG) continue;
            System.err.println("TODO: Add expression to statemenet conversion or change expressin list to statement list...");
        }
    }

    public void addExpression(Expression ex) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        if (ex != null) {
            this.fExpressions.add(ex);
        }
    }

    public List getExpressions() {
        return this.fExpressions;
    }

    public void printNode(CorePrinter output) {
        if (this.fExpressions != null) {
            int index = 0;
            for (Expression expr : this.fExpressions) {
                expr.printNode(output);
                if (index != this.fExpressions.size() - 1) {
                    output.formatPrintLn(", ");
                }
                ++index;
            }
        }
    }
}

