/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class MethodPattern
extends DLTKSearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] selector;
    public char[] declaringQualificationName;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    protected IType declaringType;
    boolean methodParameters = false;
    char[][] methodArguments;
    protected static char[][] REF_CATEGORIES = new char[][]{METHOD_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, METHOD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(char[] selector, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : (String.valueOf('{') + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(selector, countChars);
    }

    MethodPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(128, matchRule, toolkit);
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, IType declaringType, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.selector = this.isCaseSensitive() || this.isCamelCase() ? selector : CharOperation.toLowerCase(selector);
        this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        char[] cArray = this.declaringQualificationName = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        if (this.parameterSimpleNames != null) {
            this.parameterCount = this.parameterSimpleNames.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? this.parameterQualifications[i] : CharOperation.toLowerCase(this.parameterQualifications[i]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? this.parameterSimpleNames[i] : CharOperation.toLowerCase(this.parameterSimpleNames[i]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.declaringType = declaringType;
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, IMethod method, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(findDeclarations, findReferences, selector, declaringQualification, declaringSimpleName, method == null ? null : method.getDeclaringType(), matchRule, toolkit);
        this.methodParameters = true;
        this.methodArguments = this.extractMethodArguments(method);
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, String declaringSignature, char[][] arguments, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(findDeclarations, findReferences, selector, declaringQualification, declaringSimpleName, (IMethod)null, matchRule, toolkit);
        this.methodArguments = arguments;
    }

    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        this.parameterCount = 0;
        this.selector = null;
        int power = 1;
        int i = last;
        while (i >= 0) {
            if (key[i] == '{') {
                this.selector = new char[i];
                System.arraycopy(key, 0, this.selector, 0, i);
                break;
            }
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
    }

    public SearchPattern getBlankPattern() {
        return new MethodPattern(8, this.getToolkit());
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasMethodArguments() {
        return this.methodArguments != null && this.methodArguments.length > 0;
    }

    boolean hasMethodParameters() {
        return this.methodParameters;
    }

    public boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodPattern pattern = (MethodPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1) && this.matchesName(this.selector, pattern.selector);
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.selector;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.selector != null && this.parameterCount >= 0) {
                    key = MethodPattern.createIndexKey(this.selector, this.parameterCount);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0) {
                    key = MethodPattern.createIndexKey(this.selector == null ? ONE_STAR : this.selector, this.parameterCount);
                    break;
                }
                if (this.selector == null || this.selector[this.selector.length - 1] == '*') break;
                key = CharOperation.concat(this.selector, ONE_STAR, '{');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            output.append("MethodReferencePattern: ");
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName).append('.');
        }
        if (this.selector != null) {
            output.append(this.selector);
        } else {
            output.append("*");
        }
        output.append('(');
        if (this.parameterSimpleNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    output.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        return super.print(output);
    }
}

