/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.handlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.handlers.LaunchStatusDialog;
import org.eclipse.dltk.launching.ILaunchStatusHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchStatusHandler
implements ILaunchStatusHandler {
    private IDebugTarget debugTarget;
    private IProgressMonitor monitor;
    private final Object lock = new Object();
    private boolean disposed = false;
    private LaunchStatusDialog dialog = null;

    public void initialize(IDebugTarget target, IProgressMonitor monitor) {
        this.debugTarget = target;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDialogCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.dialog != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.disposed;
        }
    }

    public void updateElapsedTime(final long elapsedTime) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isDialogCreated()) {
            this.asyncExec(new Runnable(){

                public void run() {
                    LaunchStatusHandler.this.createDialog();
                }
            });
        }
        this.asyncExec(new Runnable(){

            public void run() {
                LaunchStatusHandler.this.dialog.updateElapsedTime(elapsedTime);
            }
        });
    }

    private void asyncExec(Runnable runnable) {
        DLTKDebugUIPlugin.getStandardDisplay().asyncExec(runnable);
    }

    protected void createDialog() {
        if (this.isDialogCreated()) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && PlatformUI.getWorkbench().getWorkbenchWindowCount() > 0) {
            window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        this.dialog = new LaunchStatusDialog(window != null ? window.getShell() : null, this.monitor);
        this.dialog.setCommandLine(this.debugTarget.getProcess().getAttribute(IProcess.ATTR_CMDLINE));
        this.dialog.open();
    }

    protected void disposeDialog() {
        if (this.isDialogCreated()) {
            this.dialog.close();
            this.dialog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.disposed = true;
        }
        if (this.isDialogCreated()) {
            this.asyncExec(new Runnable(){

                public void run() {
                    LaunchStatusHandler.this.disposeDialog();
                }
            });
        }
    }
}

