/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FakeModuleDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.text.IRubyPartitions;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RubyFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private boolean fInitCollapseRequires;

    protected String getCommentPartition() {
        return "__ruby_comment";
    }

    protected String getDocPartition() {
        return "__ruby_doc";
    }

    protected String getPartition() {
        return "__ruby_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new RubyPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return IRubyPartitions.RUBY_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    protected ILog getLog() {
        return RubyUI.getDefault().getLog();
    }

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ModuleDeclaration decl = this.parse(code, offset);
        if (decl instanceof FakeModuleDeclaration) {
            return null;
        }
        return this.buildCodeBlocks(decl, offset);
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return super.mayCollapse(s, ctx) || s instanceof CallExpression;
    }

    protected boolean initiallyCollapse(ASTNode s) {
        return super.initiallyCollapse(s) || s instanceof CallExpression && this.fInitCollapseRequires;
    }

    protected void initializePreferences(IPreferenceStore store) {
        super.initializePreferences(store);
        this.fInitCollapseRequires = store.getBoolean("editor_folding_init_requires");
    }

    protected AbstractASTFoldingStructureProvider.FoldingASTVisitor getFoldingVisitor(int offset) {
        return new RubyFoldingASTVisitor(offset);
    }

    protected static class RubyFoldingASTVisitor
    extends AbstractASTFoldingStructureProvider.FoldingASTVisitor {
        private final Stack declarations = new Stack();

        private DeclarationContainer peekDeclaration() {
            return (DeclarationContainer)this.declarations.peek();
        }

        private DeclarationContainer popDeclaration() {
            return (DeclarationContainer)this.declarations.pop();
        }

        private ModuleDeclarationContainer peekModuleDeclaration() {
            DeclarationContainer container;
            if (this.declarations.size() == 1 && (container = (DeclarationContainer)this.declarations.peek()) instanceof ModuleDeclarationContainer) {
                return (ModuleDeclarationContainer)container;
            }
            return null;
        }

        protected RubyFoldingASTVisitor(int offset) {
            super(offset);
        }

        public boolean visit(ModuleDeclaration s) throws Exception {
            this.declarations.push(new ModuleDeclarationContainer());
            return this.visitGeneral((ASTNode)s);
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer child = new DeclarationContainer((Declaration)s, false);
            this.peekDeclaration().addChild(child);
            this.declarations.push(child);
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(TypeDeclaration s) throws Exception {
            this.declarations.pop();
            return super.endvisit(s);
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer child = new DeclarationContainer((Declaration)s, true);
            this.peekDeclaration().addChild(child);
            this.declarations.push(child);
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(MethodDeclaration s) throws Exception {
            this.declarations.pop();
            return super.endvisit(s);
        }

        private void processDeclarations(DeclarationContainer container, int level, boolean collapsible) {
            if (container.declaration != null && (collapsible || container.foldAlways)) {
                this.add((ASTNode)container.declaration);
            }
            boolean nextCollabsible = collapsible || level > 0 && container.countChildren() > 1;
            Iterator i = container.children.iterator();
            while (i.hasNext()) {
                Object child = i.next();
                if (child instanceof DeclarationContainer) {
                    this.processDeclarations((DeclarationContainer)child, level + 1, nextCollabsible);
                    continue;
                }
                if (!(child instanceof AbstractASTFoldingStructureProvider.CodeBlock)) continue;
                this.add((AbstractASTFoldingStructureProvider.CodeBlock)child);
            }
        }

        public boolean endvisit(ModuleDeclaration s) throws Exception {
            this.handleRequireStatements();
            DeclarationContainer container = this.popDeclaration();
            this.processDeclarations(container, 0, false);
            return super.endvisit(s);
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (this.declarations.size() == 1) {
                if (node instanceof CallExpression) {
                    CallExpression call = (CallExpression)node;
                    if ("require".equals(call.getName())) {
                        ModuleDeclarationContainer container = this.peekModuleDeclaration();
                        if (container != null) {
                            container.requires.add(call);
                        }
                        return false;
                    }
                } else {
                    this.handleRequireStatements();
                }
            }
            return super.visitGeneral(node);
        }

        private void handleRequireStatements() {
            ModuleDeclarationContainer container = this.peekModuleDeclaration();
            if (container != null && !container.requires.isEmpty()) {
                CallExpression firstRequire = (CallExpression)container.requires.get(0);
                CallExpression lastRequire = (CallExpression)container.requires.get(container.requires.size() - 1);
                container.addChild(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)firstRequire, (IRegion)new Region(firstRequire.sourceStart(), lastRequire.sourceEnd() - firstRequire.sourceStart())));
                container.requires.clear();
            }
        }

        static class DeclarationContainer {
            final List children = new ArrayList();
            final Declaration declaration;
            final boolean foldAlways;

            public DeclarationContainer(Declaration declaration, boolean foldAlways) {
                this.declaration = declaration;
                this.foldAlways = foldAlways;
            }

            void addChild(DeclarationContainer child) {
                this.children.add(child);
            }

            int countChildren() {
                return this.children.size();
            }

            public String toString() {
                return this.declaration != null ? this.declaration.toString() : "(TOP)";
            }
        }

        static class ModuleDeclarationContainer
        extends DeclarationContainer {
            final List requires = new ArrayList();

            public ModuleDeclarationContainer() {
                super(null, false);
            }

            public void addChild(AbstractASTFoldingStructureProvider.CodeBlock block) {
                this.children.add(block);
            }
        }
    }
}

