/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter;

import java.util.List;
import java.util.Map;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.formatter.FormatterIndentDetector;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.formatter.JavaScriptFormatterConstants;
import org.eclipse.dltk.javascript.formatter.internal.FormatterNodeBuilder;
import org.eclipse.dltk.javascript.formatter.internal.JavaScriptFormatterContext;
import org.eclipse.dltk.javascript.formatter.internal.JavaScriptFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.JavascriptFormatterNodeRewriter;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptFormatter
extends AbstractScriptFormatter {
    private final String lineDelimiter;

    public JavaScriptFormatter(String lineDelimiter, Map<String, Object> preferences) {
        super(preferences);
        this.lineDelimiter = lineDelimiter;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel) throws FormatterException {
        String formatted;
        String input = source.substring(offset, offset + length);
        if (!input.equals(formatted = this.format(input, indentationLevel))) {
            return new ReplaceEdit(offset, length, formatted);
        }
        return new MultiTextEdit();
    }

    private int detectIndentationLevel(String input, int offset) {
        ParserProblemReporter reporter = new ParserProblemReporter();
        Script ast = (Script)new JavaScriptParser().parse(null, input.toCharArray(), (IProblemReporter)reporter);
        if (ast == null) {
            if (DLTKCore.DEBUG) {
                System.out.println(reporter.toString());
            }
            return 0;
        }
        FormatterNodeBuilder builder = new FormatterNodeBuilder();
        FormatterDocument fDocument = this.createDocument(input);
        IFormatterContainerNode root = builder.build(ast, (IFormatterDocument)fDocument);
        JavaScriptFormatterContext context = new JavaScriptFormatterContext(0);
        new JavascriptFormatterNodeRewriter(ast).rewrite(root);
        FormatterIndentDetector detector = new FormatterIndentDetector(offset);
        try {
            root.accept((IFormatterContext)context, (IFormatterWriter)detector);
            return detector.getLevel();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        return this.detectIndentationLevel(document.get(), offset);
    }

    public String format(String source, int indentationLevel) throws FormatterException {
        ParserProblemReporter reporter = new ParserProblemReporter();
        Script root = (Script)new JavaScriptParser().parse(null, source.toCharArray(), (IProblemReporter)reporter);
        if (root == null) {
            List errors = reporter.getErrors();
            if (!errors.isEmpty()) {
                throw new FormatterSyntaxProblemException(((IProblem)errors.get(0)).getMessage());
            }
            throw new FormatterSyntaxProblemException("Syntax error");
        }
        return this.format(source, root, indentationLevel);
    }

    private String format(String source, Script ast, int indentationLevel) throws FormatterException {
        FormatterNodeBuilder builder = new FormatterNodeBuilder();
        FormatterDocument document = this.createDocument(source);
        IFormatterContainerNode root = builder.build(ast, (IFormatterDocument)document);
        new JavascriptFormatterNodeRewriter(ast).rewrite(root);
        JavaScriptFormatterContext context = new JavaScriptFormatterContext(indentationLevel);
        JavaScriptFormatterWriter writer = new JavaScriptFormatterWriter((IFormatterDocument)document, this.lineDelimiter, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("wrap.comments.length"));
        writer.setLinesPreserve(1);
        writer.setPreserveSpaces(false);
        try {
            root.accept((IFormatterContext)context, (IFormatterWriter)writer);
            writer.flush((IFormatterContext)context);
            return writer.getOutput();
        }
        catch (Exception e) {
            throw new FormatterException((Throwable)e);
        }
    }

    private FormatterDocument createDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        String[] options = JavaScriptFormatterConstants.getNames();
        int i = 0;
        while (i < options.length) {
            String name = options[i];
            if (JavaScriptFormatterConstants.isBoolean(name)) {
                document.setBoolean(name, this.getBoolean(name));
            } else if (JavaScriptFormatterConstants.isInteger(name)) {
                document.setInt(name, this.getInt(name));
            } else if (JavaScriptFormatterConstants.isString(name)) {
                document.setString(name, this.getString(name));
            }
            ++i;
        }
        return document;
    }

    private static class ParserProblemReporter
    extends ProblemCollector {
        private ParserProblemReporter() {
        }

        public String toString() {
            if (this.problems == null) {
                return "No problems";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.problems.size()) {
                buffer.append(this.problems.toString());
                buffer.append("\n");
                ++i;
            }
            return buffer.toString();
        }
    }
}

