/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ti.EvaluatorStatistics;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.IPruner;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.statistics.IEvaluationStatisticsRequestor;

public class GoalEngine {
    private final IGoalEvaluatorFactory evaluatorFactory;
    private final LinkedList<WorkingPair> workingQueue = new LinkedList();
    private final HashMap<IGoal, GoalEvaluationState> goalStates = new HashMap();
    private final HashMap<GoalEvaluator, EvaluatorState> evaluatorStates = new HashMap();
    private IEvaluationStatisticsRequestor statisticsRequestor;
    private static final boolean DEBUG = false;

    public GoalEngine(IGoalEvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = evaluatorFactory;
    }

    private void storeGoal(IGoal goal, GoalState state, Object result, GoalEvaluator creator) {
        GoalEvaluationState es = new GoalEvaluationState();
        es.result = result;
        es.state = state;
        es.creator = creator;
        this.goalStates.put(goal, es);
        this.statisticsRequestor.goalStateChanged(goal, state, null);
    }

    private EvaluatorState getEvaluatorState(GoalEvaluator evaluator) {
        return this.evaluatorStates.get(evaluator);
    }

    private void putEvaluatorState(GoalEvaluator evaluator, EvaluatorState state) {
        this.evaluatorStates.put(evaluator, state);
    }

    private void notifyEvaluator(GoalEvaluator evaluator, IGoal subGoal) {
        long t = 0L;
        GoalEvaluationState subGoalState = this.goalStates.get(subGoal);
        Object result = subGoalState.result;
        GoalState state = subGoalState.state;
        if (state == GoalState.WAITING) {
            state = GoalState.RECURSIVE;
        }
        t = System.currentTimeMillis();
        IGoal[] newGoals = evaluator.subGoalDone(subGoal, result, state);
        this.statisticsRequestor.evaluatorReceivedResult(evaluator, subGoal, newGoals, System.currentTimeMillis() - t);
        if (newGoals == null) {
            newGoals = IGoal.NO_GOALS;
        }
        int i = 0;
        while (i < newGoals.length) {
            this.workingQueue.add(new WorkingPair(newGoals[i], evaluator));
            ++i;
        }
        EvaluatorState ev = this.getEvaluatorState(evaluator);
        --ev.subgoalsLeft;
        ev.subgoalsLeft += newGoals.length;
        ev.totalSubgoals += newGoals.length;
        ev.subgoals.addAll((Collection<IGoal>)Arrays.asList(newGoals));
        if (state == GoalState.DONE && result != null) {
            ++ev.successfulSubgoals;
        }
        if (ev.subgoalsLeft == 0) {
            t = System.currentTimeMillis();
            Object newRes = evaluator.produceResult();
            this.statisticsRequestor.evaluatorProducedResult(evaluator, result, System.currentTimeMillis() - t);
            GoalEvaluationState st = this.goalStates.get(evaluator.getGoal());
            Assert.isNotNull((Object)st);
            st.state = GoalState.DONE;
            st.result = newRes;
            if (st.creator != null) {
                this.notifyEvaluator(st.creator, evaluator.getGoal());
            }
        }
    }

    private EvaluatorStatistics getEvaluatorStatistics(GoalEvaluator evaluator) {
        EvaluatorState ev = this.getEvaluatorState(evaluator);
        if (ev == null) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        return new EvaluatorStatistics(ev.totalSubgoals, currentTime - ev.timeCreated, ev.totalSubgoals - ev.subgoalsLeft, ev.successfulSubgoals);
    }

    public Object evaluateGoal(IGoal rootGoal, IPruner pruner) {
        return this.evaluateGoal(rootGoal, pruner, null);
    }

    public Object evaluateGoal(IGoal rootGoal, IPruner pruner, IEvaluationStatisticsRequestor statisticsRequestor) {
        long time = 0L;
        if (statisticsRequestor == null) {
            statisticsRequestor = new IEvaluationStatisticsRequestor(){

                public void evaluationStarted(IGoal rootGoal) {
                }

                public void evaluatorInitialized(GoalEvaluator evaluator, IGoal[] subgoals, long time) {
                }

                public void evaluatorProducedResult(GoalEvaluator evaluator, Object result, long time) {
                }

                public void evaluatorReceivedResult(GoalEvaluator evaluator, IGoal finishedGoal, IGoal[] newSubgoals, long time) {
                }

                public void goalEvaluatorAssigned(IGoal goal, GoalEvaluator evaluator) {
                }

                public void goalStateChanged(IGoal goal, GoalState state, GoalState oldState) {
                }
            };
        }
        this.statisticsRequestor = statisticsRequestor;
        this.reset();
        if (pruner != null) {
            pruner.init();
        }
        this.workingQueue.add(new WorkingPair(rootGoal, null));
        statisticsRequestor.evaluationStarted(rootGoal);
        while (!this.workingQueue.isEmpty()) {
            WorkingPair pair = this.workingQueue.getFirst();
            this.workingQueue.removeFirst();
            GoalEvaluationState state = this.goalStates.get(pair.goal);
            if (state != null && pair.creator != null) {
                this.notifyEvaluator(pair.creator, pair.goal);
                continue;
            }
            boolean prune = false;
            if (pruner != null && pair.creator != null) {
                prune = pruner.prune(pair.goal, this.getEvaluatorStatistics(pair.creator));
            }
            if (prune) {
                this.storeGoal(pair.goal, GoalState.PRUNED, null, pair.creator);
                this.notifyEvaluator(pair.creator, pair.goal);
                continue;
            }
            GoalEvaluator evaluator = this.evaluatorFactory.createEvaluator(pair.goal);
            Assert.isNotNull((Object)evaluator);
            statisticsRequestor.goalEvaluatorAssigned(pair.goal, evaluator);
            time = System.currentTimeMillis();
            IGoal[] newGoals = evaluator.init();
            if (newGoals == null) {
                newGoals = IGoal.NO_GOALS;
            }
            statisticsRequestor.evaluatorInitialized(evaluator, newGoals, System.currentTimeMillis() - time);
            if (newGoals.length > 0) {
                int i = 0;
                while (i < newGoals.length) {
                    this.workingQueue.add(new WorkingPair(newGoals[i], evaluator));
                    ++i;
                }
                EvaluatorState evaluatorState = new EvaluatorState(newGoals.length);
                evaluatorState.subgoals.addAll((Collection<IGoal>)Arrays.asList(newGoals));
                this.putEvaluatorState(evaluator, evaluatorState);
                this.storeGoal(pair.goal, GoalState.WAITING, null, pair.creator);
                continue;
            }
            time = System.currentTimeMillis();
            Object result = evaluator.produceResult();
            statisticsRequestor.evaluatorProducedResult(evaluator, result, System.currentTimeMillis() - time);
            this.storeGoal(pair.goal, GoalState.DONE, result, pair.creator);
            if (pair.creator == null) continue;
            this.notifyEvaluator(pair.creator, pair.goal);
        }
        GoalEvaluationState s = this.goalStates.get(rootGoal);
        Assert.isTrue((s.state == GoalState.DONE ? 1 : 0) != 0);
        return s.result;
    }

    private void reset() {
        this.workingQueue.clear();
        this.goalStates.clear();
        this.evaluatorStates.clear();
    }

    private static class EvaluatorState {
        public long timeCreated;
        public int totalSubgoals;
        public int successfulSubgoals;
        public int subgoalsLeft;
        public List<IGoal> subgoals = new ArrayList<IGoal>();

        public EvaluatorState(int subgoalsLeft) {
            this.subgoalsLeft = subgoalsLeft;
            this.timeCreated = System.currentTimeMillis();
            this.totalSubgoals = subgoalsLeft;
        }
    }

    private static class GoalEvaluationState {
        public GoalEvaluator creator;
        public GoalState state;
        public Object result;

        private GoalEvaluationState() {
        }
    }

    private static class WorkingPair {
        private IGoal goal;
        private GoalEvaluator creator;

        public WorkingPair(IGoal goal, GoalEvaluator parent) {
            this.goal = goal;
            this.creator = parent;
        }
    }
}

