/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;

final class TransparentRef
implements IReference {
    IReference evaluateReference;
    private final String fieldId;
    private final Node node;
    ReferenceResolverContext cs;
    ModelElement parent;
    int length;
    int location;

    TransparentRef(IReference evaluateReference, Node objID, String fieldId, ModelElement parent, ReferenceResolverContext cs) {
        this.evaluateReference = evaluateReference;
        this.fieldId = fieldId;
        this.node = objID;
        this.parent = parent;
        this.cs = cs;
    }

    public IReference getChild(String key, boolean resolveLocals) {
        IReference child = this.evaluateReference.getChild(key, resolveLocals);
        return child;
    }

    public Set getChilds(boolean resolveLocals) {
        return this.evaluateReference.getChilds(resolveLocals);
    }

    public String getName() {
        return this.fieldId;
    }

    public String getParentName() {
        return this.fieldId;
    }

    public void setChild(String key, IReference ref) {
        this.evaluateReference.setChild(key, ref);
    }

    public boolean isChildishReference() {
        return false;
    }

    public void patchRef(HostCollection collection) {
        Set s = this.evaluateReference.getChilds(false);
        IReference queryElement = TypeInferencer.internalEvaluate(collection, this.getName(), this.node, this.parent, this.cs);
        if (queryElement != null && queryElement != this) {
            while (queryElement instanceof TransparentRef) {
                queryElement = ((TransparentRef)queryElement).evaluateReference;
            }
            if (!(queryElement instanceof CombinedOrReference) || !((CombinedOrReference)queryElement).testContains(this)) {
                this.evaluateReference = queryElement;
            }
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof IReference)) continue;
            IReference r = (IReference)next;
            this.evaluateReference.setChild(r.getName(), r);
        }
    }

    public void recordDelete(String fieldId) {
        this.evaluateReference.recordDelete(fieldId);
    }

    public IReference getPrototype(boolean resolveLocals) {
        return this.evaluateReference.getPrototype(false);
    }

    public void setPrototype(IReference ref) {
        this.evaluateReference.setPrototype(ref);
    }

    public void addModelElements(Collection toAdd) {
        if (this.parent != null) {
            toAdd.add(new FakeField(this.parent, this.getName(), this.location, this.length));
        }
    }

    public void setLocationInformation(ModelElement mo, int position, int length) {
        this.parent = mo;
        this.location = position;
        this.length = length;
    }

    public boolean isFunctionRef() {
        return this.evaluateReference.isFunctionRef();
    }

    public boolean isLocal() {
        return this.evaluateReference.isLocal();
    }

    public void setLocal(boolean local) {
        this.evaluateReference.setLocal(local);
    }
}

