/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.testing.AbstractTestingEngine;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public abstract class AbstractRubyTestingEngine
extends AbstractTestingEngine {
    protected static final String RUBY_TESTING_PORT = "RUBY_TESTING_PORT";
    protected static final String RUBY_TESTING_PATH = "RUBY_TESTING_PATH";
    protected static final String RUNNER_PATH = "/testing/";

    protected Bundle getBundle() {
        return RubyTestingPlugin.getDefault().getBundle();
    }

    protected File getRunnerFile(Bundle bundle, String runnerPath, String runnerName) throws CoreException {
        URL runnerScript = bundle.getEntry(String.valueOf(runnerPath) + runnerName);
        if (runnerScript == null) {
            String msg = NLS.bind((String)Messages.Delegate_runnerNotFound, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, null));
        }
        try {
            runnerScript = FileLocator.toFileURL((URL)runnerScript);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.Delegate_errorExtractingRunner, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, (Throwable)e));
        }
        try {
            return new File(new URI(runnerScript.toString()));
        }
        catch (IllegalArgumentException e) {
            String msg = NLS.bind((String)Messages.Delegate_internalErrorExtractingRunner, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, (Throwable)e));
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.Delegate_internalErrorExtractingRunner, (Object)runnerName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", msg, (Throwable)e));
        }
    }

    protected boolean isDevelopmentMode(InterpreterConfig config, String runnerName) {
        return config.getScriptFilePath() != null && config.getScriptFilePath().lastSegment().equals(runnerName);
    }

    /*
     * Exception decompiling
     */
    private static int findFreePort() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 46->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int allocatePort() throws CoreException {
        int port = AbstractRubyTestingEngine.findFreePort();
        if (port == -1) {
            this.informAndAbort("No socket available", null, 110);
        }
        return port;
    }

    protected void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.eclipse.dltk.ruby.testing", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ruby.testing", code, message, exception));
    }

    protected boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = DLTKTestingPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = AbstractRubyTestingEngine.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)"Problems Launching Unit Tests", (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    protected static IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.dltk.ruby.testing", message);
    }
}

