/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.utils.TextUtils;

public class SourceLineTrackerTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.tests.utils.SourceLineTrackerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testNotTerminatedSingleLine() {
        String input = "1234567890";
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)input);
        SourceLineTrackerTests.assertEquals((int)1, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertNull((Object)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLineLength(0));
    }

    public void testTerminatedSingleLine() {
        String input = "1234567890\r\n";
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)input);
        SourceLineTrackerTests.assertEquals((int)1, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertEquals((String)"\r\n", (String)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)input.length(), (int)tracker.getLineLength(0));
    }

    public void testTwoLines() {
        ISourceLineTracker tracker = TextUtils.createLineTracker((String)"1234567890\r\n1234567890");
        SourceLineTrackerTests.assertEquals((int)2, (int)tracker.getNumberOfLines());
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n1234567890".length(), (int)tracker.getLength());
        SourceLineTrackerTests.assertEquals((String)"\r\n", (String)tracker.getLineDelimiter(0));
        SourceLineTrackerTests.assertNull((Object)tracker.getLineDelimiter(1));
        SourceLineTrackerTests.assertEquals((int)0, (int)tracker.getLineOffset(0));
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n".length(), (int)tracker.getLineOffset(1));
        SourceLineTrackerTests.assertEquals((int)"1234567890\r\n".length(), (int)tracker.getLineLength(0));
        SourceLineTrackerTests.assertEquals((int)"1234567890".length(), (int)tracker.getLineLength(1));
    }
}

