/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.utils;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.dltk.internal.core.util.Util;

public class InternalCoreUtilTest
extends TestCase {
    public void testProblemArguments1() {
        Object[] input = new String[]{"ABC"};
        String encoded = Util.getProblemArgumentsForMarker((String[])input);
        Object[] output = Util.getProblemArgumentsFromMarker((String)encoded);
        InternalCoreUtilTest.assertTrue((boolean)Arrays.equals(input, output));
    }

    public void testProblemArguments2() {
        Object[] input = new String[]{"AAA", "BBB"};
        String encoded = Util.getProblemArgumentsForMarker((String[])input);
        Object[] output = Util.getProblemArgumentsFromMarker((String)encoded);
        InternalCoreUtilTest.assertTrue((boolean)Arrays.equals(input, output));
    }

    public void testProblemArgumentsComplex1() {
        Object[] input = new String[]{"A#1", "B#2"};
        String encoded = Util.getProblemArgumentsForMarker((String[])input);
        Object[] output = Util.getProblemArgumentsFromMarker((String)encoded);
        InternalCoreUtilTest.assertTrue((boolean)Arrays.equals(input, output));
    }

    public void testProblemArgumentsComplex2() {
        Object[] input = new String[]{"A#1", "B#2", "C+3"};
        String encoded = Util.getProblemArgumentsForMarker((String[])input);
        Object[] output = Util.getProblemArgumentsFromMarker((String)encoded);
        InternalCoreUtilTest.assertTrue((boolean)Arrays.equals(input, output));
    }

    public void testProblemArgumentsOldFormat() {
        String[] result = Util.getProblemArgumentsFromMarker((String)"1:ABC");
        InternalCoreUtilTest.assertEquals((int)1, (int)result.length);
        InternalCoreUtilTest.assertEquals((int)3, (int)result[0].length());
        InternalCoreUtilTest.assertEquals((String)"ABC", (String)result[0]);
        InternalCoreUtilTest.assertNull((Object)Util.getProblemArgumentsFromMarker((String)"1:ABC#DEF"));
        InternalCoreUtilTest.assertNull((Object)Util.getProblemArgumentsFromMarker((String)"2:ABC"));
    }

    public void testProblemArgumentsNewFormat() {
        String[] result = Util.getProblemArgumentsFromMarker((String)"+1#3#ABC");
        InternalCoreUtilTest.assertEquals((int)1, (int)result.length);
        InternalCoreUtilTest.assertEquals((int)3, (int)result[0].length());
        InternalCoreUtilTest.assertEquals((String)"ABC", (String)result[0]);
        InternalCoreUtilTest.assertNull((Object)Util.getProblemArgumentsFromMarker((String)"+1#3#ABC?"));
        InternalCoreUtilTest.assertNull((Object)Util.getProblemArgumentsFromMarker((String)"+1#4#ABC"));
        InternalCoreUtilTest.assertNull((Object)Util.getProblemArgumentsFromMarker((String)"+2#3#ABC"));
    }
}

