/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.BuildActionGroup;
import org.eclipse.dltk.internal.ui.actions.CCPActionGroup;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.actions.ImportActionGroup;
import org.eclipse.dltk.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.dltk.internal.ui.actions.refactoring.RefactorActionGroup;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.search.SearchUtil;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.ui.actions.OpenEditorActionGroup;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.ui.actions.SearchActionGroup;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.browsing.MembersView;
import org.eclipse.dltk.ui.browsing.PackagesView;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingContentProvider;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingMessages;
import org.eclipse.dltk.ui.browsing.ScriptElementTypeComparator;
import org.eclipse.dltk.ui.browsing.ToggleLinkingAction;
import org.eclipse.dltk.ui.infoviews.AbstractInfoView;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.dltk.ui.viewsupport.ProblemTableViewer;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.dltk.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ScriptBrowsingPart
extends ViewPart
implements IMenuListener,
ISelectionListener,
IViewPartInputProvider,
IExecutableExtension {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_LOGICAL_PACKAGE = "logicalPackage";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private ScriptUILabelProvider fLabelProvider;
    private ILabelProvider fTitleProvider;
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private ScriptElementTypeComparator fTypeComparator;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    private OpenEditorActionGroup fOpenEditorGroup;
    private CCPActionGroup fCCPActionGroup;
    private BuildActionGroup fBuildActionGroup;
    private ToggleLinkingAction fToggleLinkingAction;
    protected CompositeActionGroup fActionGroups;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == ScriptBrowsingPart.this.getSite().getId()) {
                ScriptBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage page = ScriptBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (page != null) {
                    ScriptBrowsingPart.this.selectionChanged(page.getActivePart(), page.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == ScriptBrowsingPart.this.getSite().getId()) {
                ScriptBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    private IDLTKLanguageToolkit fToolkit;

    public ScriptBrowsingPart() {
        this.initLinkingEnabled();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.saveState(memento);
        }
        this.saveSelectionState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    private void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTED_ELEMENTS);
            int i = 0;
            while (i < elements.length) {
                IMemento elementMem = selectionMem.createChild(TAG_SELECTED_ELEMENT);
                Object o = elements[i];
                if (o instanceof IModelElement) {
                    elementMem.putString(TAG_SELECTED_ELEMENT_PATH, ((IModelElement)elements[i]).getHandleIdentifier());
                } else if (o instanceof LogicalPackage) {
                    IScriptFolder[] packages = ((LogicalPackage)((Object)o)).getScriptFolders();
                    int j = 0;
                    while (j < packages.length) {
                        IMemento packageMem = elementMem.createChild(TAG_LOGICAL_PACKAGE);
                        packageMem.putString(TAG_SELECTED_ELEMENT_PATH, packages[j].getHandleIdentifier());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void restoreState(IMemento memento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter || this.fHasWorkingSetFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private ISelection restoreSelectionState(IMemento memento) {
        if (memento == null) {
            return null;
        }
        IMemento childMem = memento.getChild(TAG_SELECTED_ELEMENTS);
        if (childMem != null) {
            ArrayList<LogicalPackage> list = new ArrayList<LogicalPackage>();
            IMemento[] elementMem = childMem.getChildren(TAG_SELECTED_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                String javaElementHandle = elementMem[i].getString(TAG_SELECTED_ELEMENT_PATH);
                if (javaElementHandle == null) {
                    IMemento[] packagesMem = elementMem[i].getChildren(TAG_LOGICAL_PACKAGE);
                    LogicalPackage lp = null;
                    int j = 0;
                    while (j < packagesMem.length) {
                        javaElementHandle = packagesMem[j].getString(TAG_SELECTED_ELEMENT_PATH);
                        IModelElement pack = DLTKCore.create((String)javaElementHandle);
                        if (pack instanceof IScriptFolder && ((IScriptFolder)pack).exists()) {
                            if (lp == null) {
                                lp = new LogicalPackage((IScriptFolder)pack);
                            } else {
                                lp.add((IScriptFolder)pack);
                            }
                        }
                        ++j;
                    }
                    if (lp != null) {
                        list.add(lp);
                    }
                } else {
                    IModelElement element = DLTKCore.create((String)javaElementHandle);
                    if (element != null && element.exists()) {
                        list.add((LogicalPackage)element);
                    }
                }
                ++i;
            }
            return new StructuredSelection(list);
        }
        return null;
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(this.getLinkToEditorKey());
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fTypeComparator = new ScriptElementTypeComparator();
        this.fViewer = this.createViewer(parent);
        this.initDragAndDrop();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(this.fLabelProvider));
        this.fViewer.setComparator((ViewerComparator)this.createModelElementComparator());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        this.addKeyListener();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.createStatusBarUpdater(slManager));
        this.hookViewerListeners();
        this.addFilters();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.fMemento = null;
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
        this.setHelp();
    }

    public Object getAdapter(Class key) {
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        return super.getAdapter(key);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, ScriptBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected DecoratingModelLabelProvider createDecoratingLabelProvider(ScriptUILabelProvider provider) {
        return new DecoratingModelLabelProvider(provider);
    }

    protected ModelElementSorter createModelElementComparator() {
        return new ModelElementSorter();
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager slManager) {
        return new StatusBarUpdater(slManager);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    protected void initDragAndDrop() {
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        actionBars.updateActionBars();
        this.fActionGroups.fillActionBars(actionBars);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        }
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.fToggleLinkingAction);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fWorkingSetFilterActionGroup != null) {
            this.fWorkingSetFilterActionGroup.dispose();
        }
        super.dispose();
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ScriptBrowsingPart.this.handleKeyReleased(event);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent event) {
        IAction action;
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
        if (key == 0x100000E && (action = this.fBuildActionGroup.getRefreshAction()).isEnabled()) {
            action.run();
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
    }

    public void menuAboutToShow(IMenuManager menu) {
        DLTKUIPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        if (size == 1) {
            this.addOpenNewWindowAction(menu, element);
        }
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IModelElement) {
            element = ((IModelElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
    }

    protected IDLTKLanguageToolkit getToolkit() {
        return this.fToolkit;
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[8];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)this.getSite());
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[1] = this.fOpenEditorGroup;
        actionGroupArray[2] = new OpenViewActionGroup((IViewPart)this);
        this.fCCPActionGroup = new CCPActionGroup((IViewPart)this);
        actionGroupArray[3] = this.fCCPActionGroup;
        actionGroupArray[4] = new RefactorActionGroup((IViewPart)this);
        actionGroupArray[5] = new ImportActionGroup((IViewPart)this);
        this.fBuildActionGroup = new BuildActionGroup((IViewPart)this);
        actionGroupArray[6] = this.fBuildActionGroup;
        actionGroupArray[7] = new SearchActionGroup((IViewPart)this, this.getToolkit());
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        if (this.fHasWorkingSetFilter) {
            String viewId = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)viewId);
            IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ScriptBrowsingPart.this.doWorkingSetChanged(event);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getSite(), workingSetListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, this.fViewer);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetNameChange".equals(property)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean isValidElement(Object element) {
        if (!(element instanceof IModelElement)) {
            return false;
        }
        Object input = this.getViewer().getInput();
        if (input == null) {
            return false;
        }
        if (input instanceof Collection) {
            return ((Collection)input).contains(element);
        }
        return input.equals(element);
    }

    private boolean isInputResetBy(Object newInput, Object input, IWorkbenchPart part) {
        if (newInput == null) {
            return part == this.fPreviousSelectionProvider;
        }
        if (input instanceof IModelElement && newInput instanceof IModelElement) {
            return this.getTypeComparator().compare(newInput, input) > 0;
        }
        return newInput instanceof List && part instanceof PackagesView;
    }

    private boolean isInputResetBy(IWorkbenchPart part) {
        if (!(part instanceof ScriptBrowsingPart)) {
            return true;
        }
        Object thisInput = this.getViewer().getInput();
        Object partInput = ((ScriptBrowsingPart)part).getViewer().getInput();
        if (thisInput instanceof Collection) {
            thisInput = ((Collection)thisInput).iterator().next();
        }
        if (partInput instanceof Collection) {
            partInput = ((Collection)partInput).iterator().next();
        }
        if (thisInput instanceof IModelElement && partInput instanceof IModelElement) {
            return this.getTypeComparator().compare(partInput, thisInput) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object ancestor, Object element) {
        if (element instanceof IModelElement && ancestor instanceof IModelElement) {
            return !element.equals(ancestor) && this.internalIsAncestorOf((IModelElement)ancestor, (IModelElement)element);
        }
        if (element instanceof IModelElement && ancestor instanceof List) {
            List l = (List)ancestor;
            for (IModelElement anc : l) {
                if (!element.equals(anc) || !this.internalIsAncestorOf(anc, (IModelElement)element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean internalIsAncestorOf(IModelElement ancestor, IModelElement element) {
        if (element != null) {
            return element.equals(ancestor) || this.internalIsAncestorOf(ancestor, element.getParent());
        }
        return false;
    }

    private boolean isSearchResultView(IWorkbenchPart part) {
        return SearchUtil.isSearchPlugInActivated() && part instanceof ISearchResultViewPart;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.fProcessSelectionEvents || part == this || this.isSearchResultView(part) || part instanceof AbstractInfoView) {
            if (part == this) {
                this.fPreviousSelectionProvider = part;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (this.fToggleLinkingAction.isChecked() && part instanceof ITextEditor) {
            this.setSelectionFromEditor(part, selection);
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedElement = this.getSingleElementFromSelection(selection);
        if (selectedElement != null && (part == null || part.equals(this.fPreviousSelectionProvider)) && selectedElement.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = selectedElement;
        Object currentInput = this.getViewer().getInput();
        if (selectedElement != null && selectedElement.equals(currentInput)) {
            Object elementToSelect = this.findElementToSelect(selectedElement);
            if (elementToSelect != null && this.getTypeComparator().compare(selectedElement, elementToSelect) < 0) {
                this.setSelection((ISelection)new StructuredSelection(elementToSelect), true);
            } else if (elementToSelect == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (part != this.fPreviousSelectionProvider && selectedElement != null && !selectedElement.equals(currentInput) && this.isInputResetBy(selectedElement, currentInput, part)) {
            if (!this.isAncestorOf(selectedElement, currentInput)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selection.isEmpty() && !this.isInputResetBy(part)) {
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selectedElement == null && part == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = part;
            return;
        }
        this.fPreviousSelectionProvider = part;
        this.adjustInputAndSetSelection(selectedElement);
    }

    void setHasWorkingSetFilter(boolean state) {
        this.fHasWorkingSetFilter = state;
    }

    void setHasCustomSetFilter(boolean state) {
        this.fHasCustomFilter = state;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    protected void setInput(Object input) {
        this.setViewerInput(input);
        this.updateTitle();
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private void setViewerInput(Object input) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(input);
        this.fProcessSelectionEvents = true;
    }

    void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? ScriptElementLabels.getDefault().getTextLabel(element, 564049465049131L) : ((path = ((IResource)element).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : path.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return result;
        }
        IWorkingSet ws = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String wsstr = Messages.format((String)ScriptBrowsingMessages.JavaBrowsingPart_toolTip, (Object[])new String[]{ws.getLabel()});
        if (result.length() == 0) {
            return wsstr;
        }
        return Messages.format((String)ScriptBrowsingMessages.JavaBrowsingPart_toolTip2, (Object[])new String[]{result, ws.getLabel()});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected final void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    protected ScriptUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(564049465049131L, 3, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    protected ILabelProvider createTitleProvider() {
        return new ModelElementLabelProvider(256);
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected StructuredViewer createViewer(Composite parent) {
        return new ProblemTableViewer(parent, 2);
    }

    protected int getLabelProviderFlags() {
        return 786;
    }

    protected void addFilters() {
    }

    protected IContentProvider createContentProvider() {
        return new ScriptBrowsingContentProvider(true, this, this.getToolkit());
    }

    protected void setInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection();
        Object input = this.getSingleElementFromSelection(selection);
        if (!(input instanceof IModelElement) && !((input = this.getSite().getPage().getInput()) instanceof IModelElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IModelElement.class);
        }
        this.setInput(this.findInputForJavaElement((IModelElement)input));
    }

    protected void setInitialSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page = this.getSite().getPage();
        ISelection selection = null;
        if (page != null) {
            selection = page.getSelection();
        }
        if (selection instanceof ITextSelection && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)part));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (selection == null || selection.isEmpty()) {
            selection = this.restoreSelectionState(this.fMemento);
        }
        if (selection == null || selection.isEmpty()) {
            Object input = this.getSite().getPage().getInput();
            if (!(input instanceof IModelElement)) {
                if (input instanceof IAdaptable) {
                    input = input.getAdapter(IModelElement.class);
                } else {
                    return;
                }
            }
            selection = new StructuredSelection(input);
        }
        this.selectionChanged(null, selection);
    }

    protected final void setHelp() {
    }

    protected abstract String getHelpContextId();

    protected abstract String getLinkToEditorKey();

    protected void hookViewerListeners() {
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ScriptBrowsingPart.this.fProcessSelectionEvents) {
                    return;
                }
                ScriptBrowsingPart.this.fPreviousSelectedElement = ScriptBrowsingPart.this.getSingleElementFromSelection(event.getSelection());
                IWorkbenchPage page = ScriptBrowsingPart.this.getSite().getPage();
                if (page == null) {
                    return;
                }
                if (page.equals(DLTKUIPlugin.getActivePage()) && ScriptBrowsingPart.this.equals(page.getActivePart())) {
                    ScriptBrowsingPart.this.linkToEditor((IStructuredSelection)event.getSelection());
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IAction open = ScriptBrowsingPart.this.fOpenEditorGroup.getOpenAction();
                if (open.isEnabled()) {
                    open.run();
                    ScriptBrowsingPart.this.restoreSelection();
                }
            }
        });
    }

    void restoreSelection() {
    }

    void adjustInputAndSetSelection(Object o) {
        if (!(o instanceof IModelElement) && !(o instanceof List)) {
            if (o == null) {
                this.setInput(null);
            }
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        if (o instanceof IModelElement) {
            IModelElement je = (IModelElement)o;
            IModelElement elementToSelect = this.findElementToSelect(je);
            IModelElement newInput = this.findInputForJavaElement(je);
            IModelElement oldInput = null;
            if (this.getInput() instanceof IModelElement) {
                oldInput = (IModelElement)this.getInput();
            }
            if (elementToSelect == null && !this.isValidInput(newInput) && newInput == null && !this.isAncestorOf(je, oldInput)) {
                this.setInput(null);
            } else if (this.mustSetNewInput(elementToSelect, oldInput, newInput)) {
                this.setInput(newInput);
            }
            if (elementToSelect != null && elementToSelect.exists()) {
                this.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
            } else {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            }
        } else {
            this.setSelection((ISelection)new StructuredSelection(o), true);
            this.setInput(o);
        }
    }

    private boolean mustSetNewInput(IModelElement elementToSelect, IModelElement oldInput, IModelElement newInput) {
        return !(newInput != null && newInput.equals(oldInput) || elementToSelect != null && oldInput != null && elementToSelect instanceof IPackageDeclaration && elementToSelect.getParent().equals(oldInput.getParent()) && !this.isAncestorOf(this.getViewPartInput(), elementToSelect));
    }

    protected IModelElement findInputForJavaElement(IModelElement je) {
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            return je;
        }
        return this.findInputForJavaElement(je.getParent());
    }

    protected final Object findElementToSelect(Object obj) {
        if (obj instanceof IModelElement) {
            return this.findElementToSelect((IModelElement)obj);
        }
        if (obj instanceof List) {
            return obj;
        }
        return null;
    }

    protected abstract IModelElement findElementToSelect(IModelElement var1);

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final Object getSingleElementFromSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        iter = ((IStructuredSelection)selection).iterator();
        firstElement /* !! */  = iter.next();
        if (!(firstElement /* !! */  instanceof IModelElement)) {
            if (firstElement /* !! */  instanceof IMarker) {
                firstElement /* !! */  = ((IMarker)firstElement /* !! */ ).getResource();
            }
            if (firstElement /* !! */  instanceof IAdaptable) {
                je = (IModelElement)((IAdaptable)firstElement /* !! */ ).getAdapter(IModelElement.class);
                if (je == null && firstElement /* !! */  instanceof IFile) {
                    parent = ((IFile)firstElement /* !! */ ).getParent();
                    if (parent != null) {
                        return parent.getAdapter(IModelElement.class);
                    }
                    return null;
                }
                return je;
            }
            return firstElement /* !! */ ;
        }
        currentInput = this.getViewer().getInput();
        new ArrayList<E>();
        if (currentInput != null && currentInput.equals(this.findInputForJavaElement((IModelElement)firstElement /* !! */ ))) ** GOTO lbl28
        if (iter.hasNext() && selection instanceof StructuredSelection) {
            return ((StructuredSelection)selection).toList();
        }
        return firstElement /* !! */ ;
lbl-1000:
        // 1 sources

        {
            element = iter.next();
            if (!(element instanceof IModelElement)) {
                return null;
            }
            if (currentInput.equals(this.findInputForJavaElement((IModelElement)element))) continue;
            return null;
lbl28:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl29:
        // 1 sources

        return firstElement /* !! */ ;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IModelElement) {
                EditorUtility.revealInEditor(part, (IModelElement)obj);
            }
        }
    }

    void setSelectionFromEditor(IWorkbenchPart part) {
        if (!(this.fProcessSelectionEvents && this.linkBrowsingViewSelectionToEditor() && part instanceof IEditorPart)) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null) {
            this.setSelectionFromEditor(part, provider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            Object obj;
            IModelElement element = null;
            if (selection instanceof IStructuredSelection && (obj = this.getSingleElementFromSelection(selection)) instanceof IModelElement) {
                element = (IModelElement)obj;
            }
            IEditorInput ei = ((IEditorPart)part).getEditorInput();
            if (selection instanceof ITextSelection) {
                int offset = ((ITextSelection)selection).getOffset();
                element = this.getElementAt(ei, offset);
            }
            if (element != null) {
                this.adjustInputAndSetSelection(element);
                return;
            }
            if (ei instanceof IFileEditorInput) {
                IContainer container;
                IFile file = ((IFileEditorInput)ei).getFile();
                IModelElement je = (IModelElement)file.getAdapter(IModelElement.class);
                if (je == null && (container = ((IFileEditorInput)ei).getFile().getParent()) != null) {
                    je = (IModelElement)container.getAdapter(IModelElement.class);
                }
                if (je == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(je);
            }
        }
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input != null) {
            return DLTKUIPlugin.getEditorInputModelElement(input);
        }
        return null;
    }

    void setSelection(ISelection selection, boolean reveal) {
        if (selection != null && selection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(selection, reveal);
        this.fProcessSelectionEvents = true;
    }

    protected IModelElement getElementAt(IEditorInput input, int offset) {
        IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
        ISourceModule unit = manager.getWorkingCopy(input);
        if (unit != null) {
            try {
                if (unit.isConsistent()) {
                    return unit.getElementAt(offset);
                }
            }
            catch (ModelException modelException) {}
        }
        return null;
    }

    void setProcessSelectionEvents(boolean state) {
        this.fProcessSelectionEvents = state;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected void setActionGroups(CompositeActionGroup actionGroups) {
        this.fActionGroups = actionGroups;
    }

    protected void setBuildActionGroup(BuildActionGroup actionGroup) {
        this.fBuildActionGroup = actionGroup;
    }

    protected void setCCPActionGroup(CCPActionGroup actionGroup) {
        this.fCCPActionGroup = actionGroup;
    }

    protected void setCustomFiltersActionGroup(CustomFiltersActionGroup customFiltersActionGroup) {
        this.fCustomFiltersActionGroup = customFiltersActionGroup;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    protected void setOpenEditorGroup(OpenEditorActionGroup openEditorGroup) {
        this.fOpenEditorGroup = openEditorGroup;
    }

    protected OpenEditorActionGroup getOpenEditorGroup() {
        return this.fOpenEditorGroup;
    }

    protected BuildActionGroup getBuildActionGroup() {
        return this.fBuildActionGroup;
    }

    protected CCPActionGroup getCCPActionGroup() {
        return this.fCCPActionGroup;
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        DLTKUIPlugin.getDefault().getPreferenceStore().setValue(this.getLinkToEditorKey(), enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        String nature = null;
        if (data instanceof String) {
            nature = (String)data;
        } else if (data instanceof Map) {
            nature = (String)((Map)data).get("nature");
        }
        if (nature == null) {
            throw new RuntimeException(ScriptBrowsingMessages.ScriptBrowsingPart_natureAttributeMustBeSpecifiedAndCorrect);
        }
        this.fToolkit = DLTKLanguageManager.getLanguageToolkit((String)nature);
    }
}

