/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.selectionaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.selectionaction.StructureSelectHistoryAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionHistory {
    private List fHistory;
    private ScriptEditor fEditor;
    private ISelectionChangedListener fSelectionListener;
    private int fSelectionChangeListenerCounter;
    private StructureSelectHistoryAction fHistoryAction;

    public SelectionHistory(ScriptEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fHistory = new ArrayList(3);
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public void setHistoryAction(StructureSelectHistoryAction action) {
        Assert.isNotNull((Object)((Object)action));
        this.fHistoryAction = action;
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void remember(ISourceRange range) {
        this.fHistory.add(range);
        this.fHistoryAction.update();
    }

    public ISourceRange getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.fHistory.size();
        ISourceRange result = (ISourceRange)this.fHistory.remove(size - 1);
        this.fHistoryAction.update();
        return result;
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
        this.fHistoryAction.update();
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
    }
}

