/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.checks;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.definitions.ArgumentDefinition;
import org.eclipse.dltk.tcl.validators.ITclCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentsDefinitionCheck
implements ITclCheck {
    @Override
    public void checkCommands(List<TclCommand> commands, final ITclErrorReporter reporter, Map<String, String> options, IScriptProject project, ISourceLineTracker sourceLineTracker) {
        TclParserUtils.traverse(commands, (TclVisitor)new TclVisitor(){

            public boolean visit(TclCommand tclCommand) {
                Assert.isNotNull((Object)tclCommand);
                if (tclCommand.getDefinition() == null || !tclCommand.isMatched()) {
                    return true;
                }
                if ("proc".equals(tclCommand.getDefinition().getName())) {
                    Assert.isLegal((tclCommand.getArguments().size() >= 3 ? 1 : 0) != 0);
                    return this.check((TclArgument)tclCommand.getArguments().get(1));
                }
                if ("apply".equals(tclCommand.getDefinition().getName())) {
                    Assert.isLegal((tclCommand.getArguments().size() >= 2 ? 1 : 0) != 0);
                    TclArgument tclArgument = (TclArgument)tclCommand.getArguments().get(0);
                    Assert.isLegal((boolean)(tclArgument instanceof TclArgumentList));
                    TclArgumentList tclArgumentList = (TclArgumentList)tclArgument;
                    Assert.isLegal((tclArgumentList.getArguments().size() >= 2 ? 1 : 0) != 0);
                    return this.check((TclArgument)tclArgumentList.getArguments().get(0));
                }
                return true;
            }

            public boolean check(TclArgument tclArgument) {
                List list = ArgumentDefinition.get((TclArgument)tclArgument);
                boolean wasArgs = false;
                boolean wasDef = false;
                int i = 0;
                while (i < list.size()) {
                    ArgumentDefinition definition = (ArgumentDefinition)list.get(i);
                    if (definition.getName() == null) {
                        reporter.report(10003, "Bad argument definition", null, definition.getArgument().getStart(), definition.getArgument().getEnd(), 1);
                    } else {
                        int j = 0;
                        while (j < i) {
                            ArgumentDefinition other = (ArgumentDefinition)list.get(j);
                            if (definition.getName().equals(other.getName())) {
                                reporter.report(10007, "Argument with the same name has been declared", null, definition.getArgument().getStart(), definition.getArgument().getEnd(), 1);
                            }
                            ++j;
                        }
                    }
                    if ("args".equals(definition.getName())) {
                        wasArgs = true;
                        if (definition.isDefaulted() && !definition.isDefaultEmtpy()) {
                            reporter.report(10006, "\"args\" cannot be defaulted. Default value is ignored.", null, definition.getArgument().getStart(), definition.getArgument().getEnd(), 1);
                        }
                    } else {
                        if (wasArgs) {
                            reporter.report(10005, "Argument specified after \"args\"", null, definition.getArgument().getStart(), definition.getArgument().getEnd(), 1);
                        }
                        if (definition.isDefaulted()) {
                            wasDef = true;
                        } else if (wasDef) {
                            reporter.report(10004, "Non-default arg specified after default", null, definition.getArgument().getStart(), definition.getArgument().getEnd(), 1);
                        }
                    }
                    ++i;
                }
                return true;
            }
        });
    }
}

