/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.BufferChangedEvent;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBufferChangedListener;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class BufferTests
extends ModifyingResourceTests
implements IBufferChangedListener {
    static final String[] TEST_NATURES = new String[]{"org.eclipse.dltk.core.tests.testnature"};
    protected ArrayList events = null;

    public BufferTests(String name) {
        super("org.eclipse.dltk.core.tests", name);
    }

    public static Test suite() {
        return new SuiteOfTestCases.Suite(BufferTests.class);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        try {
            this.createScriptProject("P", TEST_NATURES, new String[]{""});
            this.createFolder("P/x/y");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
        this.deleteProject("P");
    }

    protected IBuffer createBuffer(String path, String content) throws CoreException {
        BufferTests.waitUntilIndexesReady();
        this.createFile(path, content);
        ISourceModule sm = this.getSourceModule(path);
        IBuffer buffer = sm.getBuffer();
        buffer.addBufferChangedListener((IBufferChangedListener)this);
        this.events = new ArrayList();
        return buffer;
    }

    protected void assertBufferEvent(int offset, int length, String text) {
        BufferTests.assertTrue((String)"events should not be null", (this.events != null ? 1 : 0) != 0);
        BufferTests.assertTrue((String)"events should not be empty", (!this.events.isEmpty() ? 1 : 0) != 0);
        BufferChangedEvent event = (BufferChangedEvent)this.events.get(0);
        BufferTests.assertEquals((String)"unexpected offset", (int)offset, (int)event.getOffset());
        BufferTests.assertEquals((String)"unexpected length", (int)length, (int)event.getLength());
        if (text == null) {
            BufferTests.assertTrue((String)"text should be null", (event.getText() == null ? 1 : 0) != 0);
        } else {
            this.assertSourceEquals("unexpected text", text, event.getText());
        }
    }

    protected void deleteBuffer(IBuffer buffer) throws CoreException {
        buffer.removeBufferChangedListener((IBufferChangedListener)this);
        IResource resource = buffer.getUnderlyingResource();
        if (resource != null) {
            this.deleteResource(resource);
        }
    }

    public void testAppend() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            int oldLength = buffer.getLength();
            buffer.append("\nclass B {}");
            this.assertBufferEvent(oldLength, 0, "\nclass B {}");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\nclass B {}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testClose() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.close();
            this.assertBufferEvent(0, 0, null);
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetUnderlyingResource() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        ISourceModule copy = null;
        try {
            IFile file = this.getFile("P/x/y/A.txt");
            BufferTests.assertEquals((String)"Unexpected underlying resource", (Object)file, (Object)buffer.getUnderlyingResource());
            copy = this.getSourceModule("P/x/y/A.txt").getWorkingCopy(null);
            BufferTests.assertEquals((String)"Unexpected underlying resource 2", (Object)file, (Object)copy.getBuffer().getUnderlyingResource());
        }
        finally {
            this.deleteBuffer(buffer);
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testDeleteBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 13, "");
            this.assertBufferEvent(0, 13, null);
            this.assertSourceEquals("unexpected buffer contents", "public class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testDeleteMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 7, "");
            this.assertBufferEvent(13, 7, null);
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\nclass A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testDeleteEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 18, "");
            this.assertBufferEvent(13, 18, null);
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\n", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetChar() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 17", (char)'i', (char)buffer.getChar(17));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetChar2() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        buffer.close();
        try {
            BufferTests.assertEquals((String)"Unexpected char at position 17", (char)'\u0000', (char)buffer.getChar(17));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetLength() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            BufferTests.assertEquals((String)"Unexpected length", (int)31, (int)buffer.getLength());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testGetText() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            this.assertSourceEquals("Unexpected text (1)", "p", buffer.getText(0, 1));
            this.assertSourceEquals("Unexpected text (2)", "public", buffer.getText(13, 6));
            this.assertSourceEquals("Unexpected text (3)", "", buffer.getText(10, 0));
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 0, "/* copyright mycompany */\n");
            this.assertBufferEvent(0, 0, "/* copyright mycompany */\n");
            this.assertSourceEquals("unexpected buffer contents", "/* copyright mycompany */\npackage x.y;\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceBeginning() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(0, 13, "package other;\n");
            this.assertBufferEvent(0, 13, "package other;\n");
            this.assertSourceEquals("unexpected buffer contents", "package other;\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 14, "public class B");
            this.assertBufferEvent(13, 14, "public class B");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class B {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testReplaceEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            int end = buffer.getLength();
            buffer.replace(end - 1, 1, "}\n");
            this.assertBufferEvent(end - 1, 1, "}\n");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\n", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertMiddle() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            buffer.replace(13, 0, "/* class comment */\n");
            this.assertBufferEvent(13, 0, "/* class comment */\n");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\n/* class comment */\npublic class A {\n}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void testInsertEnd() throws CoreException {
        IBuffer buffer = this.createBuffer("P/x/y/A.txt", "package x.y;\npublic class A {\n}");
        try {
            int end = buffer.getLength();
            buffer.replace(end, 0, "\nclass B {}");
            this.assertBufferEvent(end, 0, "\nclass B {}");
            this.assertSourceEquals("unexpected buffer contents", "package x.y;\npublic class A {\n}\nclass B {}", buffer.getContents());
            BufferTests.assertTrue((String)"should have unsaved changes", (boolean)buffer.hasUnsavedChanges());
        }
        finally {
            this.deleteBuffer(buffer);
        }
    }

    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        this.events.add(bufferChangedEvent);
    }
}

