/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.Set;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKAssociationManager;

public class DLTKAssociationManager
implements IDLTKAssociationManager {
    private final String natureId;
    private final String qualifier;
    private char[][] cachedPatterns = null;
    private final Object preferencesLock = new Object();
    private IEclipsePreferences preferences = null;

    public DLTKAssociationManager(String natureId, String qualifier) {
        this.natureId = natureId;
        this.qualifier = qualifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociatedWith(String name) {
        char[][] patterns;
        DLTKAssociationManager dLTKAssociationManager = this;
        synchronized (dLTKAssociationManager) {
            if (this.cachedPatterns == null) {
                IEclipsePreferences prefs = this.getEclipsePreferences();
                this.initPatterns(prefs.get("org.eclipse.dltk.core.filename.associations", new DefaultScope().getNode(this.qualifier).get("org.eclipse.dltk.core.filename.associations", null)));
            }
            patterns = this.cachedPatterns;
        }
        if (patterns.length != 0) {
            int i = 0;
            while (i < patterns.length) {
                char[] pattern = patterns[i];
                if (DLTKAssociationManager.match(pattern, name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void initPatterns(String value) {
        Set<String> patterns = DLTKLanguageManager.loadFilenameAssociations(this.natureId);
        if (value != null && value.length() != 0 || !patterns.isEmpty()) {
            char[][] patterns1 = value != null && value.length() != 0 ? CharOperation.splitOn(';', value.toCharArray()) : null;
            char[][] patterns2 = !patterns.isEmpty() ? CharOperation.stringArrayToCharCharArray(patterns.toArray(new String[patterns.size()])) : null;
            this.cachedPatterns = CharOperation.arrayConcat(patterns1, patterns2);
        } else {
            this.cachedPatterns = CharOperation.NO_CHAR_CHAR;
        }
    }

    private static final boolean match(char[] pattern, String name) {
        int patternEnd = pattern.length;
        int nameEnd = name.length();
        int iPattern = 0;
        int iName = 0;
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != name.charAt(iName) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if (Character.toLowerCase(name.charAt(iName)) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEclipsePreferences getEclipsePreferences() {
        Object object = this.preferencesLock;
        synchronized (object) {
            if (this.preferences != null) {
                return this.preferences;
            }
        }
        InstanceScope context = new InstanceScope();
        final IEclipsePreferences eclipsePreferences = context.getNode(this.qualifier);
        Object object2 = this.preferencesLock;
        synchronized (object2) {
            this.preferences = eclipsePreferences;
        }
        IEclipsePreferences.INodeChangeListener nodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == eclipsePreferences) {
                    Object object = DLTKAssociationManager.this.preferencesLock;
                    synchronized (object) {
                        DLTKAssociationManager.this.preferences = null;
                    }
                }
            }
        };
        ((IEclipsePreferences)eclipsePreferences.parent()).addNodeChangeListener(nodeListener);
        IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    DLTKAssociationManager.this.initPatterns((String)event.getNewValue());
                }
            }
        };
        eclipsePreferences.addPreferenceChangeListener(preferenceListener);
        return eclipsePreferences;
    }
}

