/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementCacheListener;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ElementCache;

public class SourceModuleInfoCache
implements ISourceModuleInfoCache {
    private final ElementCache cache;
    static long allAccess = 0L;
    static long miss = 0L;
    static long closes = 0L;
    private IElementChangedListener changedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IModelElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        private void processDelta(IModelElementDelta delta) {
            block7: {
                IModelElement element = delta.getElement();
                if (delta.getKind() == 2 || delta.getKind() == 4) {
                    if (element.getElementType() == 5 && (delta.getKind() == 2 || this.isContentChanged(delta) || this.isWorkingCopy(delta))) {
                        SourceModuleInfoCache.this.remove((ISourceModule)element);
                    }
                    if (element.getElementType() == 3 && delta.getAffectedChildren().length == 0) {
                        IProjectFragment fragment = (IProjectFragment)element;
                        try {
                            fragment.accept(new IModelElementVisitor(){

                                public boolean visit(IModelElement element) {
                                    if (element.getElementType() == 5) {
                                        SourceModuleInfoCache.this.remove((ISourceModule)element);
                                        return false;
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block7;
                            e.printStackTrace();
                        }
                    }
                }
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }

        private final boolean isContentChanged(IModelElementDelta delta) {
            return (delta.getFlags() & 0x4001) == 1;
        }

        private final boolean isWorkingCopy(IModelElementDelta delta) {
            return (delta.getFlags() & 0x10000) != 0;
        }
    };
    private static final boolean DEBUG = false;

    public SourceModuleInfoCache() {
        double ratio = 50.0;
        this.cache = new ElementCache((int)(50.0 * ratio));
        this.cache.setLoadFactor(0.9);
        this.cache.addListener(new IElementCacheListener(){

            public void close(Object element) {
                ++closes;
            }
        });
    }

    public void start() {
        DLTKCore.addElementChangedListener(this.changedListener);
    }

    public void stop() {
        DLTKCore.removeElementChangedListener(this.changedListener);
    }

    private final ISourceModuleInfoCache.ISourceModuleInfo cacheGet(ISourceModule module) {
        ++allAccess;
        SoftReference ref = (SoftReference)this.cache.get(module);
        return ref != null ? (ISourceModuleInfoCache.ISourceModuleInfo)ref.get() : null;
    }

    public ISourceModuleInfoCache.ISourceModuleInfo get(ISourceModule module) {
        ISourceModuleInfoCache.ISourceModuleInfo info = this.cacheGet(module);
        if (info == null) {
            ++miss;
            info = new SourceModuleInfo();
            this.cache.put(module, new SoftReference<ISourceModuleInfoCache.ISourceModuleInfo>(info));
            this.cache.ensureSpaceLimit(1, module);
            return info;
        }
        return info;
    }

    public void remove(ISourceModule element) {
        this.cache.remove(element);
        this.cache.resetSpaceLimit(50, element);
    }

    public void clear() {
        this.cache.flush();
    }

    private static class SourceModuleInfo
    implements ISourceModuleInfoCache.ISourceModuleInfo {
        private Map<Object, Object> map;

        private SourceModuleInfo() {
        }

        public synchronized Object get(Object key) {
            if (this.map == null) {
                return null;
            }
            return this.map.get(key);
        }

        public synchronized void put(Object key, Object value) {
            if (this.map == null) {
                this.map = new HashMap<Object, Object>();
            }
            this.map.put(key, value);
        }

        public synchronized void remove(Object key) {
            if (this.map != null) {
                this.map.remove(key);
            }
        }

        public synchronized boolean isEmpty() {
            return this.map == null || this.map.isEmpty();
        }
    }
}

