/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension3;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.builder.IScriptBuilderExtension;
import org.eclipse.dltk.internal.core.builder.BuildParticipantManager;
import org.eclipse.dltk.internal.core.builder.BuildProblemReporter;
import org.eclipse.dltk.internal.core.builder.BuildUtils;
import org.eclipse.dltk.internal.core.builder.ExternalModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.SourceModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.SubTaskProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardScriptBuilder
implements IScriptBuilder,
IScriptBuilderExtension {
    private static final boolean DEBUG = false;
    private static final int WORK_BUILD = 100;
    private List<IProblemReporter> reporters = null;
    private boolean beginBuildDone = false;
    private boolean endBuildNeeded = false;
    private IBuildParticipant[] participants = null;
    private IDLTKLanguageToolkit toolkit = null;

    @Override
    public IStatus buildModelElements(IScriptProject project, List<ISourceModule> elements, IProgressMonitor monitor, int buildType) {
        monitor.beginTask("", 100);
        try {
            this.buildModules(project, elements, buildType, BuildUtils.subMonitorFor(monitor, 100));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void buildExternalElements(IScriptProject project, List<ISourceModule> externalElements, IProgressMonitor monitor, int buildType) {
        this.beginBuild(buildType, monitor);
        List<IBuildParticipantExtension2> extensions = this.selectExtension(IBuildParticipantExtension2.class);
        if (extensions != null) {
            int remainingWork = externalElements.size();
            Iterator<ISourceModule> j = externalElements.iterator();
            while (j.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                ISourceModule module = j.next();
                monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildExternalModuleSubTask, (Object)String.valueOf(remainingWork), (Object)module.getElementName()));
                ExternalModuleBuildContext context = new ExternalModuleBuildContext(module, buildType);
                try {
                    int i = 0;
                    while (i < extensions.size()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        extensions.get(i).buildExternalModule(context);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorBuildingExternalModule, (Object)module.getElementName()), e);
                }
                --remainingWork;
            }
        }
    }

    private <T> List<T> selectExtension(Class<T> clazz) {
        if (this.participants != null) {
            int count = 0;
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (clazz.isInstance(participant)) {
                    ++count;
                }
                ++i;
            }
            if (count != 0) {
                ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>(count);
                int i2 = 0;
                while (i2 < this.participants.length) {
                    IBuildParticipant participant = this.participants[i2];
                    if (clazz.isInstance(participant)) {
                        IBuildParticipant casted = participant;
                        result.add(casted);
                    }
                    ++i2;
                }
                return result;
            }
        }
        return null;
    }

    private void buildModules(IScriptProject project, List<ISourceModule> elements, int buildType, IProgressMonitor monitor) {
        monitor.beginTask(Messages.ValidatorBuilder_buildingModules, elements.size());
        if (this.toolkit != null) {
            this.buildNatureModules(project, buildType, elements, monitor);
        }
        monitor.done();
    }

    private void buildNatureModules(IScriptProject project, int buildType, List<ISourceModule> modules, IProgressMonitor monitor) {
        this.beginBuild(buildType, monitor);
        if (this.participants.length == 0) {
            return;
        }
        int counter = 0;
        this.reporters = new ArrayList<IProblemReporter>(modules.size());
        Iterator<ISourceModule> j = modules.iterator();
        while (j.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ISourceModule module = j.next();
            monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildModuleSubTask, (Object)String.valueOf(modules.size() - counter), (Object)module.getElementName()));
            SourceModuleBuildContext context = new SourceModuleBuildContext(module, buildType);
            if (context.reporter != null) {
                this.buildModule(context);
                this.reporters.add(context.reporter);
            }
            monitor.worked(1);
            ++counter;
        }
    }

    private void beginBuild(int buildType, IProgressMonitor monitor) {
        if (!this.beginBuildDone) {
            monitor.subTask(Messages.ValidatorBuilder_InitializeBuilders);
            this.endBuildNeeded = false;
            int count = 0;
            int j = 0;
            while (j < this.participants.length) {
                boolean useParticipant;
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    useParticipant = ((IBuildParticipantExtension)((Object)participant)).beginBuild(buildType);
                    this.endBuildNeeded = true;
                } else {
                    useParticipant = true;
                }
                if (useParticipant) {
                    if (count < j) {
                        this.participants[count] = this.participants[j];
                    }
                    ++count;
                }
                ++j;
            }
            this.participants = BuildParticipantManager.copyFirst(this.participants, count);
            this.beginBuildDone = true;
        }
    }

    private void buildModule(IBuildContext context) {
        int k = 0;
        while (k < this.participants.length) {
            IBuildParticipant participant = this.participants[k];
            try {
                participant.build(context);
            }
            catch (CoreException e) {
                DLTKCore.error(Messages.StandardScriptBuilder_errorBuildingModule, e);
            }
            ++k;
        }
    }

    @Override
    public IStatus buildResources(IScriptProject project, List<IResource> resources, IProgressMonitor monitor, int buildType) {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, resources.size() * 2);
        try {
            sub.beginTask("", resources.size());
            try {
                for (IResource resource : resources) {
                    String template = Messages.ValidatorBuilder_clearingResourceMarkers;
                    sub.subTask(NLS.bind((String)template, (Object)resource.getName()));
                    resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
                    resource.deleteMarkers("org.eclipse.dltk.core.task", true, 2);
                    sub.worked(1);
                }
            }
            catch (CoreException e) {
                String msg = Messages.ValidatorBuilder_errorDeleteResourceMarkers;
                DLTKCore.error(msg, e);
            }
        }
        finally {
            sub.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void clean(IScriptProject project, IProgressMonitor monitor) {
        List<IBuildParticipantExtension3> extensions = this.selectExtension(IBuildParticipantExtension3.class);
        if (extensions != null) {
            for (IBuildParticipantExtension3 extension : extensions) {
                extension.clean();
            }
        }
        IProject p = project.getProject();
        try {
            p.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
            p.deleteMarkers("org.eclipse.dltk.core.task", true, 2);
        }
        catch (CoreException e) {
            DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorCleaning, (Object)p.getName()), e);
        }
    }

    @Override
    public IScriptBuilder.DependencyResponse getDependencies(IScriptProject project, int buildType, Set<ISourceModule> localElements, Set<ISourceModule> externalElements, Set oldExternalFolders, Set externalFolders) {
        if (this.participants == null) {
            return null;
        }
        HashSet<ISourceModule> localDependencies = null;
        HashSet<ISourceModule> externalDependencies = null;
        boolean fullLocal = false;
        int i = 0;
        while (i < this.participants.length) {
            IScriptBuilder.DependencyResponse response;
            IBuildParticipant participant = this.participants[i];
            if (participant instanceof IBuildParticipantExtension2 && (response = ((IBuildParticipantExtension2)((Object)participant)).getDependencies(buildType, localElements, externalElements, oldExternalFolders, externalFolders)) != null) {
                if (response.isFullExternalBuild()) {
                    return response;
                }
                if (response.isFullLocalBuild()) {
                    fullLocal = true;
                } else if (!response.getLocalDependencies().isEmpty()) {
                    if (localDependencies == null) {
                        localDependencies = new HashSet<ISourceModule>();
                    }
                    localDependencies.addAll(response.getLocalDependencies());
                }
                if (!response.getExternalDependencies().isEmpty()) {
                    if (externalDependencies == null) {
                        externalDependencies = new HashSet<ISourceModule>();
                    }
                    externalDependencies.addAll(response.getExternalDependencies());
                }
            }
            ++i;
        }
        if (externalDependencies == null) {
            if (fullLocal) {
                return IScriptBuilder.DependencyResponse.FULL_LOCAL_BUILD;
            }
            return IScriptBuilder.DependencyResponse.createLocal(localDependencies);
        }
        return IScriptBuilder.DependencyResponse.create(fullLocal, localDependencies, externalDependencies);
    }

    @Override
    public void initialize(IScriptProject project) {
        this.toolkit = project.getLanguageToolkit();
        if (this.toolkit != null) {
            this.participants = BuildParticipantManager.getBuildParticipants(project, this.toolkit.getNatureId());
        }
        this.beginBuildDone = false;
        this.endBuildNeeded = false;
    }

    @Override
    public void endBuild(IScriptProject project, IProgressMonitor monitor) {
        if (this.endBuildNeeded) {
            monitor.subTask(Messages.ValidatorBuilder_finalizeBuild);
            SubTaskProgressMonitor finalizeMonitor = new SubTaskProgressMonitor(monitor, Messages.ValidatorBuilder_finalizeBuild);
            int j = 0;
            while (j < this.participants.length) {
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)finalizeMonitor);
                }
                ++j;
            }
            this.endBuildNeeded = false;
        }
        if (this.reporters != null) {
            for (IProblemReporter reporter : this.reporters) {
                ((BuildProblemReporter)reporter).flush();
            }
            this.reporters = null;
        }
        this.participants = null;
        this.toolkit = null;
        this.beginBuildDone = false;
    }
}

