/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.dltk.internal.core.index2.SourceModulesRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProjectFragmentRequest
extends AbstractIndexRequest {
    protected final IProjectFragment fragment;

    public ExternalProjectFragmentRequest(ProjectIndexer2 indexer, IProjectFragment fragment, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.fragment = fragment;
    }

    @Override
    protected String getName() {
        return this.fragment.getElementName();
    }

    @Override
    protected void run() throws CoreException, IOException {
        Set<ISourceModule> sourceModules = this.getExternalSourceModules();
        this.projectIndexer.request(new SourceModulesRequest(this.projectIndexer, this.fragment.getPath(), sourceModules, this.progressJob));
    }

    protected IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment(this.fragment);
    }

    private Set<ISourceModule> getExternalSourceModules() throws ModelException {
        final HashSet<ISourceModule> modules = new HashSet<ISourceModule>();
        IModelElementVisitor visitor = new IModelElementVisitor(){

            public boolean visit(IModelElement element) {
                if (element.getElementType() == 5) {
                    if (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule) {
                        modules.add((ISourceModule)element);
                    }
                    return false;
                }
                return true;
            }
        };
        this.fragment.accept(visitor);
        return modules;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalProjectFragmentRequest other = (ExternalProjectFragmentRequest)obj;
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }
}

