/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.semantic.highlighting;

import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingReconciler;
import org.eclipse.dltk.ui.ColorPreferenceConverter;
import org.eclipse.dltk.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.IColorManagerExtension;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private SemanticHighlighting[] fSemanticHighlightings;
    private HighlightingStyle[] fHighlightings;
    private ScriptEditor fEditor;
    private ScriptSourceViewer fSourceViewer;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private ScriptSourceViewerConfiguration fConfiguration;
    private ScriptPresentationReconciler fPresentationReconciler;

    public void install(ScriptEditor editor, ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        ScriptTextTools textTools = this.getTextTools();
        if (textTools != null) {
            this.fSemanticHighlightings = textTools.getSemanticHighlightings();
            this.fConfiguration = textTools.createSourceViewerConfiguraton(preferenceStore, (ITextEditor)editor);
        }
        if (this.fEditor != null) {
            Assert.isNotNull((Object)((Object)this.fConfiguration));
            IPresentationReconciler presReconciler = this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
            this.fPresentationReconciler = presReconciler instanceof ScriptPresentationReconciler ? (ScriptPresentationReconciler)presReconciler : null;
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    public void install(ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, HighlightedRange[][] hardcodedRanges) {
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            ISemanticHighlighter updater;
            ScriptTextTools textTools = this.getTextTools();
            if (textTools != null && (updater = textTools.getSemanticPositionUpdater()) != null) {
                updater.initialize(this.fPresenter, this.fHighlightings);
                ModuleSource code = new ModuleSource(this.fSourceViewer.getDocument().get());
                ISemanticHighlighter.UpdateResult result = updater.reconcile((IModuleSource)code, Collections.<HighlightedPosition>emptyList());
                this.fPresenter.updatePresentation(null, result.addedPositions, HighlightedPosition.NO_POSITIONS);
            }
        }
    }

    public HighlightingStyle getHighlighting(int pos) {
        return this.fHighlightings[pos];
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fSemanticHighlightings = null;
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private boolean isEnabled() {
        if (this.fSemanticHighlightings == null) {
            return false;
        }
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            SemanticHighlighting sh = this.fSemanticHighlightings[i];
            if (!sh.isSemanticOnly()) {
                return true;
            }
            if (this.fPreferenceStore.getBoolean(sh.getEnabledPreferenceKey())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private TextAttribute createTextAttribute(IColorManager manager, IPreferenceStore ps, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String bgKey) {
        int style;
        this.addColor(colorKey);
        if (bgKey != null) {
            this.addColor(bgKey);
        }
        Color color = null;
        Color bgcolor = null;
        if (colorKey != null) {
            color = manager.getColor(colorKey);
        }
        if (bgKey != null) {
            bgcolor = manager.getColor(bgKey);
        }
        int n = style = ps.getBoolean(boldKey) ? 1 : 0;
        if (ps.getBoolean(italicKey)) {
            style |= 2;
        }
        if (ps.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (ps.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, bgcolor, style);
    }

    private TextAttribute createTextAttribute(IColorManager manager, IPreferenceStore ps, String colorKey, String bgKey) {
        return this.createTextAttribute(manager, ps, colorKey, String.valueOf(colorKey) + "_bold", String.valueOf(colorKey) + "_italic", String.valueOf(colorKey) + "_strikethrough", String.valueOf(colorKey) + "_underline", bgKey);
    }

    private void initializeHighlightings() {
        ScriptTextTools textTools = this.getTextTools();
        if (textTools != null) {
            Assert.isNotNull((Object)this.fSemanticHighlightings);
            this.fHighlightings = new HighlightingStyle[this.fSemanticHighlightings.length];
            int a = 0;
            while (a < this.fSemanticHighlightings.length) {
                SemanticHighlighting sh = this.fSemanticHighlightings[a];
                TextAttribute ta = this.createTextAttribute(this.fColorManager, this.fPreferenceStore, sh.getPreferenceKey(), sh.getBackgroundPreferenceKey());
                boolean isEnabled = !sh.isSemanticOnly() || this.fPreferenceStore.getBoolean(sh.getEnabledPreferenceKey());
                this.fHighlightings[a] = new HighlightingStyle(ta, isEnabled, sh);
                ++a;
            }
        }
    }

    protected ScriptTextTools getTextTools() {
        return this.fEditor != null ? this.fEditor.getTextTools() : null;
    }

    private void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.removeColor(this.fSemanticHighlightings[i].getPreferenceKey());
            ++i;
        }
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (this.affectsEnablement(event)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String preferenceKey = semanticHighlighting.getPreferenceKey();
            if (preferenceKey != null && preferenceKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String bpreferenceKey = semanticHighlighting.getBackgroundPreferenceKey();
                if (bpreferenceKey != null && bpreferenceKey.equals(event.getProperty())) {
                    this.adaptToTextBackgroundChange(this.fHighlightings[i], event);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String boldKey = String.valueOf(preferenceKey) + "_bold";
                    if (boldKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String italicKey = String.valueOf(preferenceKey) + "_italic";
                        if (italicKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String strikethroughKey = String.valueOf(preferenceKey) + "_strikethrough";
                            if (strikethroughKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String underlineKey = String.valueOf(preferenceKey) + "_underline";
                                if (underlineKey.equals(event.getProperty())) {
                                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                } else if (semanticHighlighting.isSemanticOnly() && semanticHighlighting.getEnabledPreferenceKey().equals(event.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[i], event);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private boolean affectsEnablement(PropertyChangeEvent event) {
        if (this.fSemanticHighlightings == null) {
            return false;
        }
        String relevantKey = null;
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            if (event.getProperty().equals(this.fSemanticHighlightings[i].getEnabledPreferenceKey())) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < this.fSemanticHighlightings.length) {
            String key = this.fSemanticHighlightings[i].getEnabledPreferenceKey();
            if (!key.equals(relevantKey) && this.fPreferenceStore.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void adaptToTextBackgroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = ColorPreferenceConverter.asRGB(event.getNewValue());
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), color, oldAttr.getStyle()));
        }
    }

    private void adaptToEnablementChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = ColorPreferenceConverter.asRGB(event.getNewValue());
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
    }

    private void removeColor(String colorKey) {
        if (this.fColorManager instanceof IColorManagerExtension) {
            ((IColorManagerExtension)((Object)this.fColorManager)).unbindColor(colorKey);
        }
    }

    public SemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }
}

