/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PerformanceMonitor {
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    public static final boolean PERFOMANCE_MONITORING_IS_ACTIVE = true;
    private static final PerformanceMonitor mon = new PerformanceMonitor();

    public static PerformanceMonitor getDefault() {
        return mon;
    }

    public synchronized void begin(String id) {
        Entry entry = this.entries.get(id);
        if (entry == null) {
            entry = new Entry();
            this.entries.put(id, entry);
        }
        entry.startTime = System.currentTimeMillis();
    }

    public synchronized void end(String id) {
        long cur = System.currentTimeMillis();
        Entry entry = this.entries.get(id);
        if (entry != null) {
            entry.value += cur - entry.startTime;
            ++entry.operations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        HashMap<String, Entry> copy;
        PerformanceMonitor performanceMonitor = this;
        synchronized (performanceMonitor) {
            copy = new HashMap<String, Entry>(this.entries);
        }
        Object[] keys = copy.keySet().toArray(new String[copy.size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            Entry entry = (Entry)copy.get(id);
            if (entry.operations > 1L) {
                System.out.println("(" + (String)id + ") \t:" + entry.value + " /" + entry.value / entry.operations + " ops:" + entry.operations);
            } else {
                System.out.println("(" + (String)id + ") \t:" + entry.value);
            }
            ++n2;
        }
    }

    public synchronized void add(String id, long value) {
        Entry entry = this.entries.get(id);
        if (entry == null) {
            entry = new Entry();
            this.entries.put(id, entry);
        }
        entry.value += value;
        ++entry.operations;
    }

    private static class Entry {
        long value;
        long operations;
        long startTime;

        private Entry() {
        }
    }
}

