/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;

public abstract class AbstractBracesConfiguration
implements IBracesConfiguration {
    protected final IFormatterDocument document;
    protected String indentingSettingName;
    protected String bracesSettingName;
    protected String keepSameLineSettingName;
    protected String newLineSettingName;

    public AbstractBracesConfiguration(IFormatterDocument document) {
        this.document = document;
    }

    protected IFormatterDocument getDocument() {
        return this.document;
    }

    public boolean isIndenting() {
        if (this.indentingSettingName != null) {
            return this.document.getBoolean(this.indentingSettingName);
        }
        return false;
    }

    public boolean isBracesIndenting() {
        if (this.bracesSettingName != null) {
            return "next.line.indented".equals(this.document.getString(this.bracesSettingName));
        }
        return false;
    }

    public boolean isStatementContinuation() {
        return true;
    }

    public int insertBeforeOpenBrace() {
        if (this.bracesSettingName != null) {
            String value = this.document.getString(this.bracesSettingName);
            return "next.line.indented".equals(value) || "next.line".equals(value) ? 2 : 1;
        }
        return 0;
    }

    public int insertAfterOpenBrace() {
        return 2;
    }

    public int insertBeforeCloseBrace() {
        return 2;
    }

    public int insertAfterCloseBrace() {
        if (this.keepSameLineSettingName != null) {
            return this.document.getBoolean(this.keepSameLineSettingName) ? 0 : 2;
        }
        if (this.newLineSettingName != null) {
            return this.document.getBoolean(this.newLineSettingName) ? 2 : 0;
        }
        return 0;
    }

    private static final String describe(int value) {
        switch (value) {
            case 0: {
                return "UNDEFINED";
            }
            case 1: {
                return "ONE_SPACE";
            }
            case 2: {
                return "LINE_BREAK";
            }
            case 3: {
                return "EMPTY_SPACE";
            }
        }
        return String.valueOf(value);
    }

    public String toString() {
        return "beforeOpenBrace=" + AbstractBracesConfiguration.describe(this.insertBeforeOpenBrace()) + ", afterOpenBrace=" + AbstractBracesConfiguration.describe(this.insertAfterOpenBrace()) + ", beforeCloseBrace=" + AbstractBracesConfiguration.describe(this.insertBeforeCloseBrace()) + ", afterCloseBrace=" + AbstractBracesConfiguration.describe(this.insertAfterCloseBrace());
    }
}

