/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.itcl.internal.core.IncrTclResolver;
import org.eclipse.dltk.itcl.internal.core.parser.IncrTclCommandDetector;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclBodyDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclExInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodCallStatement;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodDeclaration;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclInstProc;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.core.extensions.ISelectionExtension;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclSelectionEngine;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;

public class IncrTclSelectionExtension
implements ISelectionExtension {
    public void selectionOnKeywordOrFunction(SelectionOnKeywordOrFunction key, TclSelectionEngine engine) {
        ASTNode originalNode = key.getOriginalNode();
        if (originalNode instanceof TclStatement) {
            this.processIncrTclCommandCalls((TclStatement)originalNode, engine);
        }
    }

    private void processIncrTclInstanceVariable(IncrTclInstanceVariable node, TclSelectionEngine engine) {
        TypeDeclaration declaringType;
        IModelElement type;
        SimpleReference classInstanceName = node.getClassInstanceName();
        if (classInstanceName.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= classInstanceName.sourceEnd() && (type = engine.findElementFromNode((ASTNode)(declaringType = node.getDeclaringType()))) != null) {
            engine.addSelectionElement(type);
        }
    }

    private void processIncrTclCommandCalls(TclStatement node, TclSelectionEngine engine) {
        ASTNode scopeParent;
        if (node.getCount() == 0) {
            return;
        }
        ASTNode parent = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)node);
        String prefix = TclParseUtil.getElementFQN((ASTNode)parent, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule());
        Expression commandExpr = node.getAt(0);
        String command = TclParseUtil.getNameFromNode((ASTNode)commandExpr);
        if ("$this".equals(command) && (scopeParent = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)node)) instanceof IncrTclMethodDeclaration) {
            SimpleReference callName;
            IModelElement child;
            Expression callExpr;
            IncrTclMethodDeclaration method = (IncrTclMethodDeclaration)scopeParent;
            ASTNode type = method.getDeclaringType();
            TclResolver resolver = new TclResolver((ISourceModule)engine.getSourceModule(), engine.getAssistParser().getModule());
            IModelElement typeElement = resolver.findModelElementFrom(type);
            if (commandExpr.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= commandExpr.sourceEnd()) {
                engine.addSelectionElement(typeElement);
            }
            if (node.getCount() > 1 && (callExpr = node.getAt(1)).sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= callExpr.sourceEnd() && callExpr instanceof SimpleReference && typeElement instanceof IParent && (child = TclResolver.findChildrenByName((String)(callName = (SimpleReference)callExpr).getName(), (IParent)((IParent)typeElement))) != null) {
                engine.addSelectionElement(child);
            }
        }
        if (command != null && command.startsWith("::")) {
            String name = command.substring(2);
            String[] split = TclParseUtil.tclSplit((String)name);
            IModelElement[] typeMixin = IncrTclResolver.findTypeMixin(engine.tclNameToKey(name), split[split.length - 1], engine.getScriptProject());
            this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
        } else if (command != null) {
            IModelElement[] typeMixin;
            String[] split = TclParseUtil.tclSplit((String)command);
            if (parent instanceof ModuleDeclaration) {
                typeMixin = IncrTclResolver.findTypeMixin(engine.tclNameToKey(command), split[split.length - 1], engine.getScriptProject());
                this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
            } else {
                typeMixin = IncrTclResolver.findTypeMixin(String.valueOf(prefix) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(command), split[split.length - 1], engine.getScriptProject());
                this.checkMixinTypeForMethod(node, commandExpr, typeMixin, prefix, engine);
            }
        }
    }

    private boolean checkMixinTypeForMethod(TclStatement node, Expression commandExpr, IModelElement[] typeMixin, String prefix, TclSelectionEngine engine) {
        int i = 0;
        while (i < typeMixin.length) {
            block14: {
                if (commandExpr.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= commandExpr.sourceEnd()) {
                    engine.addSelectionElement(typeMixin[i]);
                    return true;
                }
                Expression callExpr = node.getAt(1);
                if (node.getCount() > 1 && typeMixin[i] instanceof IParent && callExpr.sourceStart() <= engine.getActualSelectionStart() && engine.getActualSelectionStart() <= callExpr.sourceEnd()) {
                    String call = TclParseUtil.getNameFromNode((ASTNode)callExpr);
                    IParent eParent = (IParent)typeMixin[i];
                    if (call != null) {
                        IModelElement[] children = null;
                        try {
                            children = eParent.getChildren();
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                        }
                        if (children != null) {
                            int j = 0;
                            while (j < children.length) {
                                if (children[j].getElementType() == 9 && children[j].getElementName().equals(call)) {
                                    engine.addSelectionElement(children[j]);
                                    return true;
                                }
                                ++j;
                            }
                        }
                        if (eParent instanceof IType) {
                            IType type = (IType)eParent;
                            try {
                                String[] superClasses = type.getSuperClasses();
                                TclParseUtil.getNameFromNode((ASTNode)commandExpr);
                                if (superClasses != null) {
                                    int j = 0;
                                    while (j < superClasses.length) {
                                        IModelElement[] ptypeMixin = IncrTclResolver.findTypeMixin(String.valueOf(prefix.length() > 0 ? String.valueOf(prefix) + IMixinRequestor.MIXIN_NAME_SEPARATOR : "") + engine.tclNameToKey(superClasses[j]), superClasses[j], engine.getScriptProject());
                                        String[] split = TclParseUtil.tclSplit((String)superClasses[j]);
                                        this.checkMixinTypeForMethod(node, commandExpr, ptypeMixin, split[split.length - 1], engine);
                                        ++j;
                                    }
                                }
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG) break block14;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private void processSelectIncrTclMethodDeclaration(ExtendedTclMethodDeclaration node, int position, TclSelectionEngine engine) {
        ASTNode type = node.getDeclaringType();
        if (type instanceof TypeDeclaration) {
            SimpleReference ref = node.getTypeNameRef();
            IModelElement parent = engine.findElementFromNode(type);
            if (parent != null && parent instanceof IParent) {
                if (node.getNameStart() <= position && position <= node.getNameEnd()) {
                    IModelElement methodElement = TclResolver.findChildrenByName((String)node.getName(), (IParent)((IParent)parent));
                    engine.addSelectionElement(methodElement);
                    return;
                }
                if (ref != null && ref.sourceStart() <= position && position <= ref.sourceEnd()) {
                    engine.addSelectionElement(parent);
                }
            }
        }
    }

    private void processSelectIncrTclMethod(IncrTclMethodCallStatement call, int position, TclSelectionEngine engine) {
        FieldDeclaration instanceVar = call.getInstanceVariable();
        SimpleReference callName = call.getCallName();
        SimpleReference instName = call.getInstNameRef();
        if (instanceVar != null && instanceVar instanceof IncrTclInstanceVariable) {
            IModelElement parent;
            IncrTclInstanceVariable instanceVariable;
            TypeDeclaration declaringType;
            if (callName.sourceStart() <= position && position <= callName.sourceEnd() && (declaringType = (instanceVariable = (IncrTclInstanceVariable)instanceVar).getDeclaringType()) != null && (parent = engine.findElementFromNode((ASTNode)declaringType)) != null) {
                if (engine.checkMethodFrom(declaringType, callName, parent)) {
                    return;
                }
                String typeMixin = String.valueOf(TclParseUtil.getElementFQN((ASTNode)declaringType, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                engine.findMethodMixin(String.valueOf(typeMixin) + engine.tclNameToKey(callName.getName()), callName.getName());
                ASTNode nde = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)declaringType);
                ArrayList supersToHandle = new ArrayList();
                engine.fillSuperClassesTo(declaringType, supersToHandle);
                TypeDeclaration prev = declaringType;
                while (supersToHandle.size() > 0) {
                    String superClassName = (String)supersToHandle.get(0);
                    supersToHandle.remove(0);
                    TypeDeclaration sType = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)nde, (String)superClassName);
                    if (sType != null) {
                        prev = sType;
                        engine.fillSuperClassesTo(sType, supersToHandle);
                        IModelElement sParent = engine.findElementFromNode((ASTNode)sType);
                        if (engine.checkMethodFrom(sType, callName, sParent)) {
                            return;
                        }
                        String sTypeMixin = String.valueOf(TclParseUtil.getElementFQN((ASTNode)sType, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                        this.findIncrTclMethodMixin(String.valueOf(sTypeMixin) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                        continue;
                    }
                    String sTypeMixin = "";
                    if (prev != null) {
                        ASTNode prevParent = TclParseUtil.getPrevParent((ModuleDeclaration)engine.getAssistParser().getModule(), (ASTNode)prev);
                        sTypeMixin = prevParent instanceof ModuleDeclaration ? String.valueOf(engine.tclNameToKey(superClassName)) + IMixinRequestor.MIXIN_NAME_SEPARATOR : String.valueOf(TclParseUtil.getElementFQN((ASTNode)prevParent, (String)IMixinRequestor.MIXIN_NAME_SEPARATOR, (ModuleDeclaration)engine.getAssistParser().getModule())) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(superClassName) + IMixinRequestor.MIXIN_NAME_SEPARATOR;
                    }
                    this.findIncrTclMethodMixin(String.valueOf(sTypeMixin) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                    this.findIncrTclMethodMixin(String.valueOf(engine.tclNameToKey(superClassName)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                }
            }
        } else if (instanceVar != null && instanceVar instanceof IncrTclExInstanceVariable) {
            IncrTclExInstanceVariable instanceVariable = (IncrTclExInstanceVariable)instanceVar;
            IType type = (IType)instanceVariable.getDeclaringClassParameter().resolveElement();
            if (type != null && instName.sourceStart() <= position && position <= instName.sourceEnd()) {
                engine.addElementFromASTNode((ASTNode)instanceVariable);
            } else if (type != null && callName.sourceStart() <= position && position <= callName.sourceEnd()) {
                String prevClass;
                String[] superClasses;
                ArrayList<String> supersToHandle;
                block20: {
                    String typeMixin = TclParseUtil.getFQNFromModelElement((IModelElement)type, (String)"::");
                    if (typeMixin.startsWith("::")) {
                        typeMixin = typeMixin.substring(2);
                    }
                    this.findIncrTclMethodMixin(String.valueOf(engine.tclNameToKey(typeMixin)) + IMixinRequestor.MIXIN_NAME_SEPARATOR + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                    supersToHandle = new ArrayList<String>();
                    superClasses = null;
                    try {
                        superClasses = type.getSuperClasses();
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block20;
                        e.printStackTrace();
                    }
                }
                if (superClasses != null) {
                    int i = 0;
                    while (i < superClasses.length) {
                        supersToHandle.add(superClasses[i]);
                        ++i;
                    }
                }
                if ((prevClass = type.getFullyQualifiedName()).startsWith("::")) {
                    prevClass = prevClass.substring(2);
                }
                while (supersToHandle.size() > 0) {
                    String superClassName = (String)supersToHandle.get(0);
                    supersToHandle.remove(0);
                    if (!superClassName.startsWith("::")) continue;
                    this.findIncrTclMethodMixin(String.valueOf(superClassName.substring(2)) + engine.tclNameToKey(callName.getName()), callName.getName(), engine);
                }
            }
        }
        if (engine.getSelectionElementsSize() == 0 && instName.sourceStart() <= position && position <= instName.sourceEnd()) {
            engine.addElementFromASTNode((ASTNode)instanceVar);
        }
    }

    private void findIncrTclMethodMixin(String pattern, String name, TclSelectionEngine engine) {
        IScriptProject project = engine.getScriptProject();
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(project).find(String.valueOf(pattern) + "*");
        int pos = pattern.indexOf(IMixinRequestor.MIXIN_NAME_SEPARATOR);
        if (find.length == 0 && pos != -1) {
            String newPattern = pattern.substring(0, pos);
            find = TclMixinModel.getInstance().getMixin(project).find(String.valueOf(newPattern) + "*");
        }
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                IncrTclInstProc field;
                if (allObjects[j] != null && allObjects[j] instanceof IncrTclInstProc && name.equals((field = (IncrTclInstProc)allObjects[j]).getName())) {
                    engine.addSelectionElement(field.getModelElement());
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void selectionOnAST(ASTNode node, TclSelectionEngine engine) {
        if (node instanceof IncrTclMethodDeclaration) {
            this.processSelectIncrTclMethodDeclaration((ExtendedTclMethodDeclaration)node, engine.getActualSelectionStart(), engine);
            if (engine.getSelectionElementsSize() > 0) {
                return;
            }
        }
    }

    public void selectionOnNode(ASTNode node, int position, TclSelectionEngine engine) {
        IncrTclExInstanceVariable ex;
        IncrTclCommandDetector.IncrTclGlobalClassParameter declaringClassParameter;
        IModelElement resolveElement;
        if (node instanceof IncrTclMethodCallStatement) {
            this.processSelectIncrTclMethod((IncrTclMethodCallStatement)node, position, engine);
        } else if (node instanceof IncrTclMethodDeclaration) {
            this.processSelectIncrTclMethodDeclaration((ExtendedTclMethodDeclaration)node, engine.getActualSelectionStart(), engine);
        } else if (node instanceof TclStatement) {
            this.processIncrTclCommandCalls((TclStatement)node, engine);
        } else if (node instanceof IncrTclInstanceVariable) {
            this.processIncrTclInstanceVariable((IncrTclInstanceVariable)node, engine);
        } else if (node instanceof IncrTclExInstanceVariable && (resolveElement = (declaringClassParameter = (ex = (IncrTclExInstanceVariable)node).getDeclaringClassParameter()).resolveElement()) != null) {
            engine.addSelectionElement(resolveElement);
        }
    }

    public IModelElement findElementParent(ASTNode node, String name, IParent parent, TclSelectionEngine engine) {
        if (node instanceof IncrTclBodyDeclaration) {
            ISourceModule module;
            TclResolver resolver;
            IModelElement parentElement;
            IncrTclBodyDeclaration body = (IncrTclBodyDeclaration)node;
            ASTNode type = body.getDeclaringType();
            if (parent instanceof IModelElement && (parentElement = (resolver = new TclResolver(module = (ISourceModule)((IModelElement)parent).getAncestor(5), engine.getAssistParser().getModule())).findModelElementFrom(type)) != null && parentElement instanceof IParent) {
                return TclResolver.findChildrenByName((String)body.getName(), (IParent)((IParent)parentElement));
            }
        }
        return null;
    }

    public void findVariables(String name, ASTNode parent, int beforePosition, TclSelectionEngine engine) {
        if (parent instanceof IncrTclMethodDeclaration) {
            IncrTclMethodDeclaration method;
            TypeDeclaration type;
            if (name.startsWith("$")) {
                name = name.substring(1);
            }
            if ((type = (TypeDeclaration)(method = (IncrTclMethodDeclaration)parent).getDeclaringType()) != null) {
                List fieldList = type.getFieldList();
                for (FieldDeclaration field : fieldList) {
                    if (!field.getName().equals(name)) continue;
                    engine.addElementFromASTNode((ASTNode)field);
                }
            }
        }
    }
}

