/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.dltk.launching.sourcelookup.IProjectLookupResult;
import org.eclipse.dltk.launching.sourcelookup.ProjectSourceLookup;

public class ScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            URI uri = frame.getSourceURI();
            if ("unknown".equalsIgnoreCase(uri.getScheme())) {
                return null;
            }
            String path = uri.getPath();
            if (path.length() == 0) {
                return null;
            }
            String root = this.getProjectRoot();
            if (path.startsWith(root) && path.charAt(root.length()) == '/') {
                return path.substring(root.length() + 1);
            }
            IFile[] files = ScriptSourceLookupParticipant.getWorkspaceRoot().findFilesForLocation((IPath)new Path(path));
            IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                if (file.exists() && file.getProject().equals((Object)project)) {
                    return file.getProjectRelativePath().toString();
                }
                ++i;
            }
            return path;
        }
        return null;
    }

    protected String getProjectRoot() throws CoreException {
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        return project.getLocationURI().getPath();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] elements = super.findSourceElements(object);
        if (elements != null && elements.length > 0) {
            return elements;
        }
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            URI uri = frame.getSourceURI();
            if ("unknown".equalsIgnoreCase(uri.getScheme())) {
                return null;
            }
            String path = uri.getPath();
            if (path == null || path.length() == 0) {
                return null;
            }
            Path pathObj = new Path(path);
            if (pathObj.isEmpty()) {
                return null;
            }
            ILaunchConfiguration launchConfiguration = this.getDirector().getLaunchConfiguration();
            IProject project = LaunchConfigurationUtils.getProject(launchConfiguration);
            ProjectSourceLookup lookup = new ProjectSourceLookup(project);
            IProjectLookupResult result = lookup.find((IPath)pathObj);
            if (result != null) {
                return result.toArray();
            }
            return new Object[]{new DBGPSourceModule((ScriptProject)lookup.getScriptProject(), path, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame)};
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

