/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.tcl.internal.ui.preferences.ProjectBuildJob;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclPreferencesMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;

public class TclEnvironmentPropertyPage
extends PropertyPage {
    private Combo fEnvironments;
    private IEnvironment[] environments;
    private Button indexerEnabled;
    private Button builderEnabled;
    private Button localValidator;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(TclPreferencesMessages.TclEnvironmentPropertyPage_environmentLabel);
        this.fEnvironments = new Combo(composite, 12);
        this.fEnvironments.setLayoutData((Object)new GridData(4, -1, true, false));
        this.environments = EnvironmentManager.getEnvironments();
        String[] items = new String[this.environments.length + 1];
        items[0] = TclPreferencesMessages.TclEnvironmentPropertyPage_detectAutomatically;
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        String envId = this.getCurrentEnvironment(project);
        int selection = 0;
        int i = 0;
        while (i < this.environments.length) {
            IEnvironment env = this.environments[i];
            items[i + 1] = env.getName();
            if (envId != null && envId.equals(env.getId())) {
                selection = i + 1;
            }
            ++i;
        }
        this.fEnvironments.setItems(items);
        this.fEnvironments.select(selection);
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        this.indexerEnabled = new Button(composite, 32);
        GridData indexerData = new GridData(768);
        indexerData.horizontalSpan = 2;
        this.indexerEnabled.setLayoutData((Object)indexerData);
        this.indexerEnabled.setText(TclPreferencesMessages.TclEnvironmentPropertyPage_IndexerEnabled);
        this.indexerEnabled.setSelection(!"disabled".equals(scriptProject.getOption("org.eclipse.dltk.core.indexer", false)));
        this.builderEnabled = new Button(composite, 32);
        GridData builderData = new GridData(768);
        builderData.horizontalSpan = 2;
        this.builderEnabled.setLayoutData((Object)builderData);
        this.builderEnabled.setText(TclPreferencesMessages.TclEnvironmentPropertyPage_BuilderEnabled);
        this.builderEnabled.setSelection(!"disabled".equals(scriptProject.getOption("org.eclipse.dltk.core.builder", false)));
        this.localValidator = new Button(composite, 32);
        GridData localData = new GridData(768);
        localData.horizontalSpan = 2;
        this.localValidator.setLayoutData((Object)localData);
        this.localValidator.setText(TclPreferencesMessages.TclEnvironmentPropertyPage_localTclChecker);
        this.localValidator.setSelection("enabled".equals(new ProjectScope(project).getNode("org.eclipse.dltk.tcl.core").get("org.eclipse.dltk.tcl.core.localValidator", "disabled")));
        return composite;
    }

    public boolean performOk() {
        boolean wasBuilder;
        boolean wasIndexer;
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        int selection = this.fEnvironments.getSelectionIndex();
        try {
            if (selection <= 0) {
                EnvironmentManager.setEnvironmentId((IProject)project, null);
            } else if (selection <= this.environments.length) {
                EnvironmentManager.setEnvironment((IProject)project, (IEnvironment)this.environments[selection - 1]);
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        boolean newIndexer = this.indexerEnabled.getSelection();
        boolean bl = wasIndexer = !"disabled".equals(scriptProject.getOption("org.eclipse.dltk.core.indexer", false));
        if (wasIndexer != newIndexer) {
            scriptProject.setOption("org.eclipse.dltk.core.indexer", newIndexer ? "enabled" : "disabled");
            if (newIndexer) {
                new ProjectIndexJob(project).schedule(500L);
            }
        }
        boolean newBuilder = this.builderEnabled.getSelection();
        boolean bl2 = wasBuilder = !"disabled".equals(scriptProject.getOption("org.eclipse.dltk.core.builder", false));
        if (wasBuilder != newBuilder) {
            scriptProject.setOption("org.eclipse.dltk.core.builder", newBuilder ? "enabled" : "disabled");
            if (!newBuilder) {
                new ProjectBuildJob(project).schedule(500L);
            }
        }
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.dltk.tcl.core");
        node.put("org.eclipse.dltk.tcl.core.localValidator", this.localValidator.getSelection() ? "enabled" : "disabled");
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return super.performOk();
    }

    private String getCurrentEnvironment(IProject project) {
        return EnvironmentManager.getEnvironmentId((IProject)project, (boolean)false);
    }

    private static class ProjectIndexJob
    extends Job {
        private final IProject project;

        public ProjectIndexJob(IProject project) {
            super(NLS.bind((String)TclPreferencesMessages.TclEnvironmentPropertyPage_IndexingJobName, (Object)project.getName()));
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ProjectIndexerManager.indexProject((IProject)this.project);
            return Status.OK_STATUS;
        }
    }
}

