/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;

public class BuiltinSourceModule
extends AbstractExternalSourceModule
implements ISourceModule {
    public BuiltinSourceModule(BuiltinScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuiltinSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public InputStream getContents() {
        String builtinModuleContent = this.getSourceModuleContent();
        if (builtinModuleContent == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(builtinModuleContent.getBytes());
        return input;
    }

    public String getFileName() {
        return this.getPath().toOSString();
    }

    public IPath getFullPath() {
        return new Path(this.getName());
    }

    public String getName() {
        return this.getElementName();
    }

    public boolean isBuiltin() {
        return true;
    }

    protected char[] getBufferContent() {
        String content = this.getSourceModuleContent();
        if (content != null) {
            return content.toCharArray();
        }
        return new char[0];
    }

    protected String getModuleType() {
        return "DLTK Builtin Source Module: ";
    }

    protected String getNatureId() throws CoreException {
        IScriptProject project = this.getScriptProject();
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(project);
        return toolkit != null ? toolkit.getNatureId() : null;
    }

    protected org.eclipse.dltk.core.ISourceModule getOriginalSourceModule() {
        return new BuiltinSourceModule((BuiltinScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    private String getSourceModuleContent() {
        BuiltinProjectFragment fragment = (BuiltinProjectFragment)this.getProjectFragment();
        String builtinModuleContent = fragment.builtinProvider.getBuiltinModuleContent(this.getName());
        return builtinModuleContent;
    }
}

