/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.Messages;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelOperation;

public class ProjectRefreshOperation
extends ModelOperation {
    private ModelElementDelta delta = null;

    public ProjectRefreshOperation(IScriptProject[] projects) {
        super(projects, new IModelElement[]{DLTKCore.create(ResourcesPlugin.getWorkspace().getRoot())}, false);
    }

    protected void executeOperation() throws ModelException {
        IModelElement[] projects = this.elementsToProcess;
        this.beginTask(Messages.ProjectRefreshOperation_0, (projects != null ? projects.length * 3 : 0) + 1);
        if (projects != null) {
            IModelElement[] iModelElementArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement project = iModelElementArray[n2];
                if (project.getElementType() == 2) {
                    this.refreshProject((IScriptProject)project);
                }
                ++n2;
            }
        }
        if (this.delta != null) {
            this.addDelta(this.delta);
            this.delta = null;
        }
        this.worked(1);
        this.done();
    }

    private void refreshProject(IScriptProject project) throws ModelException {
        ISourceModule module;
        int n;
        int n2;
        ISourceModule[] iSourceModuleArray;
        IModelElement element;
        int n3;
        int n4;
        IModelElement[] iModelElementArray;
        IProjectFragment fragment;
        HashSet<ISourceModule> modules = new HashSet<ISourceModule>();
        IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
        int n5 = iProjectFragmentArray.length;
        int n6 = 0;
        while (n6 < n5) {
            fragment = iProjectFragmentArray[n6];
            if (!fragment.isExternal() && fragment.getKind() == 1) {
                iModelElementArray = fragment.getChildren();
                n4 = iModelElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    element = iModelElementArray[n3];
                    if (element.getElementType() == 4 && element.exists()) {
                        iSourceModuleArray = ((IScriptFolder)element).getSourceModules();
                        n2 = iSourceModuleArray.length;
                        n = 0;
                        while (n < n2) {
                            module = iSourceModuleArray[n];
                            modules.add(module);
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        this.worked(1);
        project.close();
        iProjectFragmentArray = project.getProjectFragments();
        n5 = iProjectFragmentArray.length;
        n6 = 0;
        while (n6 < n5) {
            fragment = iProjectFragmentArray[n6];
            if (!fragment.isExternal() && fragment.getKind() == 1) {
                iModelElementArray = fragment.getChildren();
                n4 = iModelElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    element = iModelElementArray[n3];
                    if (element.getElementType() == 4) {
                        iSourceModuleArray = ((IScriptFolder)element).getSourceModules();
                        n2 = iSourceModuleArray.length;
                        n = 0;
                        while (n < n2) {
                            module = iSourceModuleArray[n];
                            if (!modules.remove(module)) {
                                if (this.delta == null) {
                                    this.delta = this.newModelElementDelta();
                                }
                                this.delta.added(module);
                            }
                            ++n;
                        }
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        this.worked(1);
        for (ISourceModule module2 : modules) {
            if (this.delta == null) {
                this.delta = this.newModelElementDelta();
            }
            this.delta.removed(module2);
            IResource resource = module2.getResource();
            if (resource == null) continue;
            this.delta.find(project).addResourceDelta(resource);
        }
        this.worked(1);
    }
}

