/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class TraditionalHierarchyViewer
extends TypeHierarchyViewer {
    public TraditionalHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part, IPreferenceStore store) {
        super(parent, (IContentProvider)new TraditionalHierarchyContentProvider(lifeCycle), lifeCycle, part, store);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.TraditionalHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.TraditionalHierarchyViewer_title;
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            TraditionalHierarchyContentProvider contentProvider = (TraditionalHierarchyContentProvider)this.getContentProvider();
            int expandLevel = contentProvider.getExpandLevel();
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class TraditionalHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public TraditionalHierarchyContentProvider(TypeHierarchyLifeCycle provider) {
            super(provider);
        }

        public int getExpandLevel() {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input != null) {
                    return this.getDepth(hierarchy, input) + 2;
                }
                return 5;
            }
            return 2;
        }

        private int getDepth(ITypeHierarchy hierarchy, IType input) {
            int max = 0;
            IType[] superType = hierarchy.getSuperclass(input);
            if (superType == null) {
                return 0;
            }
            int q = 0;
            while (q < superType.length) {
                int c = this.getDepth(hierarchy, superType[q]);
                if (c > max) {
                    max = c;
                }
                ++q;
            }
            return max;
        }

        protected final void getRootTypes(List res) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input == null) {
                    IType[] classes = hierarchy.getRootClasses();
                    int i = 0;
                    while (i < classes.length) {
                        res.add(classes[i]);
                        ++i;
                    }
                } else {
                    IType[] roots = hierarchy.getRootClasses();
                    res.addAll((Collection)Arrays.asList(roots));
                }
            }
        }

        protected final void getTypesInHierarchy(IType type, List res) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType[] types = hierarchy.getSubtypes(type);
                boolean isHierarchyOnType = hierarchy.getType() != null;
                boolean isClass = true;
                if (isClass || isHierarchyOnType) {
                    int i = 0;
                    while (i < types.length) {
                        res.add(types[i]);
                        ++i;
                    }
                }
            }
        }

        protected IType[] getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

