/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinference;

import java.text.MessageFormat;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;

public abstract class ReferenceLocation {
    public static final ReferenceLocation UNKNOWN = new ReferenceLocation(){

        public ReferenceSource getSource() {
            return ReferenceSource.UNKNOWN;
        }

        public int getNameStart() {
            return 0;
        }

        public int getNameEnd() {
            return 0;
        }

        public int getDeclarationStart() {
            return 0;
        }

        public int getDeclarationEnd() {
            return 0;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };

    public abstract ReferenceSource getSource();

    public ISourceModule getSourceModule() {
        return this.getSource().getSourceModule();
    }

    public abstract int getDeclarationStart();

    public abstract int getDeclarationEnd();

    public abstract int getNameStart();

    public abstract int getNameEnd();

    public static ReferenceLocation create(ReferenceSource source, int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
        return new SimpleLocation(source, declarationStart, declarationEnd, nameStart, nameEnd);
    }

    public static ReferenceLocation create(ReferenceSource source, int start, int end) {
        return new RangeLocation(source, start, end);
    }

    private static class RangeLocation
    extends ReferenceLocation {
        private final ReferenceSource source;
        private final int start;
        private final int end;

        public RangeLocation(ReferenceSource source, int start, int end) {
            this.source = source;
            this.start = start;
            this.end = end;
        }

        public ReferenceSource getSource() {
            return this.source;
        }

        public int getDeclarationEnd() {
            return this.end;
        }

        public int getDeclarationStart() {
            return this.start;
        }

        public int getNameEnd() {
            return this.end;
        }

        public int getNameStart() {
            return this.start;
        }

        public String toString() {
            return this.source + "[" + this.start + ".." + this.end + "]";
        }
    }

    private static class SimpleLocation
    extends ReferenceLocation {
        private final ReferenceSource source;
        private final int declarationStart;
        private final int declarationEnd;
        private final int nameStart;
        private final int nameEnd;

        public SimpleLocation(ReferenceSource source, int declarationStart, int declarationEnd, int nameStart, int nameEnd) {
            this.source = source;
            this.declarationStart = declarationStart;
            this.declarationEnd = declarationEnd;
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        public ReferenceSource getSource() {
            return this.source;
        }

        public int getDeclarationEnd() {
            return this.declarationEnd;
        }

        public int getDeclarationStart() {
            return this.declarationStart;
        }

        public int getNameEnd() {
            return this.nameEnd;
        }

        public int getNameStart() {
            return this.nameStart;
        }

        public String toString() {
            return this.source + MessageFormat.format("[{0}..{1},{2}..{3}]", this.declarationStart, this.declarationEnd, this.nameStart, this.nameEnd);
        }
    }
}

