/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemCategoryManager;
import org.eclipse.dltk.internal.javascript.ti.JSDocProblem;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.parser.JSProblemIdentifier;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.javascript.parser.jsdoc.SimpleJSDocParser;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IJSDocTypeChecker;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParser;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.osgi.util.NLS;

public class JSDocSupport
implements IModelBuilder {
    private static final String DOTS = "...";
    protected static final String[] RETURN_TAGS = new String[]{"@returns", "@return", "@type"};
    public static final String[] TYPE_TAGS = new String[]{"@type"};

    public String getFeatureId() {
        return JSDocSupport.class.getName();
    }

    public int priorityFor(ITypeInfoContext context) {
        return 0;
    }

    public static JSDocTags parse(Comment comment) {
        return new SimpleJSDocParser().parse(comment.getText(), comment.sourceStart());
    }

    public void processMethod(FunctionStatement statement, IModelBuilder.IMethod method, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        Comment comment = JSDocSupport.getFunctionComment(statement);
        if (comment == null) {
            return;
        }
        JSDocTags tags = JSDocSupport.parse(comment);
        this.processMethod(method, tags, reporter, typeChecker);
    }

    public void processMethod(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        if (method.getType() == null) {
            this.parseType(method, tags, RETURN_TAGS, reporter, typeChecker);
        }
        this.parseParams(method, tags, reporter, typeChecker);
        this.parseDeprecation(method, tags, reporter);
        this.parsePrivate(method, tags, reporter);
        this.parseProtected(method, tags, reporter);
        this.parseConstructor(method, tags, reporter);
        this.parseThrows(method, tags, reporter, typeChecker);
        this.parseSuppressWarnings(method, tags, reporter);
    }

    protected void parseSuppressWarnings(IModelBuilder.IElement element, JSDocTags tags, JSProblemReporter reporter) {
        List suppressWarnings = tags.list("@SuppressWarnings");
        if (!suppressWarnings.isEmpty()) {
            for (JSDocTag tag : suppressWarnings) {
                this.processSuppressWarnings(tag, reporter, element);
            }
        }
    }

    private void parseThrows(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        if (typeChecker != null) {
            List throwsTags = tags.list("@throws");
            for (JSDocTag throwsTag : throwsTags) {
                String value = throwsTag.value();
                String[] split = value.split(" ");
                if (split.length <= 0 || !this.isBraced(split[0])) continue;
                JSType type = this.translateTypeName(this.cutBraces(split[0]), throwsTag, reporter);
                typeChecker.checkType(type, throwsTag);
            }
        }
    }

    public static Comment getCallComment(CallExpression call) {
        CallExpression node = call;
        while (node != null) {
            Comment doc;
            if (node instanceof JSNode && (doc = ((JSNode)node).getDocumentation()) != null) {
                return doc;
            }
            if (node instanceof Statement || !(node instanceof JSNode)) break;
            node = ((JSNode)node).getParent();
        }
        return null;
    }

    public static Comment getFunctionComment(FunctionStatement statement) {
        VariableDeclaration variable;
        Comment documentation = statement.getDocumentation();
        if (documentation != null) {
            return documentation;
        }
        if (statement.getParent() instanceof BinaryOperation) {
            BinaryOperation binary = (BinaryOperation)statement.getParent();
            if (binary.getOperation() == 104 && binary.getRightExpression() == statement && (documentation = binary.getLeftExpression().getDocumentation()) != null) {
                return documentation;
            }
        } else if (statement.getParent() instanceof PropertyInitializer) {
            PropertyInitializer property = (PropertyInitializer)statement.getParent();
            if (property.getValue() == statement && (documentation = property.getName().getDocumentation()) != null) {
                return documentation;
            }
        } else if (statement.getParent() instanceof VariableDeclaration && (variable = (VariableDeclaration)statement.getParent()).getInitializer() == statement && variable.getParent() instanceof VariableStatement) {
            return ((VariableStatement)variable.getParent()).getDocumentation();
        }
        return null;
    }

    private void parseConstructor(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@constructor") != null) {
            method.setConstructor(true);
            this.validateSingleTag(tags, "@constructor", reporter);
        }
    }

    private void parsePrivate(IModelBuilder.IMember member, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@private") != null) {
            member.setPrivate(true);
            this.validateSingleTag(tags, "@private", reporter);
        }
    }

    private void parseProtected(IModelBuilder.IMember member, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@protected") != null) {
            member.setProtected(true);
            this.validateSingleTag(tags, "@protected", reporter);
        }
    }

    private void validateSingleTag(JSDocTags tags, String tagName, JSProblemReporter reporter) {
        if (reporter != null && tags.count(tagName) > 1) {
            List t = tags.list(tagName);
            for (JSDocTag tag : t.subList(1, t.size())) {
                this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, tag, tag.name());
            }
        }
    }

    public void processVariable(VariableDeclaration declaration, IModelBuilder.IVariable variable, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        Comment comment = declaration.getDocumentation();
        if (comment == null) {
            IVariableStatement statement = declaration.getStatement();
            List vars = statement.getVariables();
            if (!vars.isEmpty() && vars.get(0) == declaration) {
                comment = statement.getDocumentation();
                if (comment == null) {
                    return;
                }
            } else {
                return;
            }
        }
        JSDocTags tags = JSDocSupport.parse(comment);
        if (variable.getType() == null) {
            this.parseType(variable, tags, TYPE_TAGS, reporter, typeChecker);
        }
        this.parseDeprecation(variable, tags, reporter);
        this.parsePrivate(variable, tags, reporter);
        this.parseProtected(variable, tags, reporter);
    }

    private void parseDeprecation(IModelBuilder.IMember member, JSDocTags tags, JSProblemReporter reporter) {
        if (tags.get("@deprecated") != null) {
            member.setDeprecated(true);
            this.validateSingleTag(tags, "@deprecated", reporter);
        }
    }

    protected void parseParams(IModelBuilder.IMethod method, JSDocTags tags, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        List paramTags = tags.list("@param");
        if (paramTags.isEmpty()) {
            return;
        }
        int problemCount = 0;
        HashMap<String, RecordType> objectPropertiesTypes = new HashMap<String, RecordType>();
        HashSet<String> processedParams = new HashSet<String>();
        ParamInfo pp = new ParamInfo();
        for (JSDocTag tag : paramTags) {
            String token;
            pp.clear();
            Tokenizer st = new Tokenizer(tag.value());
            if (st.hasMoreTokens() && this.isBraced(token = st.peek())) {
                String type = this.cutBraces(token);
                if (type.startsWith(DOTS)) {
                    pp.varargs = true;
                    type = type.substring(DOTS.length());
                } else if (type.endsWith(DOTS)) {
                    pp.varargs = true;
                    type = type.substring(0, type.length() - DOTS.length());
                } else if (type.endsWith("=")) {
                    type = type.substring(0, type.length() - 1);
                    pp.optional = true;
                }
                pp.type = type;
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                String paramName = st.nextToken();
                if (paramName.startsWith("[") && paramName.endsWith("]")) {
                    pp.optional = true;
                    int defaultValueSeperatorIndex = (paramName = paramName.substring(1, paramName.length() - 1)).indexOf(61);
                    if (defaultValueSeperatorIndex != -1) {
                        paramName = paramName.substring(0, defaultValueSeperatorIndex);
                    }
                }
                String propertyName = null;
                int propertiesObjectIndex = paramName.indexOf(46);
                if (propertiesObjectIndex != -1) {
                    propertyName = paramName.substring(propertiesObjectIndex + 1);
                    String objectName = paramName.substring(0, propertiesObjectIndex);
                    RecordType propertiesType = (RecordType)objectPropertiesTypes.get(objectName);
                    if (propertiesType == null) {
                        propertiesType = TypeInfoModelFactory.eINSTANCE.createRecordType();
                        propertiesType.setTarget(TypeInfoModelFactory.eINSTANCE.createType());
                        propertiesType.getTarget().setName(String.valueOf('{') + objectName + '}');
                        objectPropertiesTypes.put(objectName, propertiesType);
                        IModelBuilder.IParameter param = method.getParameter(objectName);
                        if (param != null) {
                            param.setType(propertiesType);
                        } else {
                            ++problemCount;
                            this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.UNKNOWN_PARAM, tag, objectName);
                        }
                    }
                    Property property = TypeInfoModelFactory.eINSTANCE.createProperty();
                    property.setName(propertyName);
                    if (pp.type != null) {
                        JSType type = this.translateTypeName(pp.type, tag, reporter);
                        if (typeChecker != null) {
                            typeChecker.checkType(type, tag);
                        }
                        property.setType(type);
                    }
                    if (pp.optional) {
                        property.setAttribute("OPTIONAL", Boolean.TRUE);
                    }
                    propertiesType.getMembers().add((Object)property);
                    continue;
                }
                if (method.getParameter(paramName) != null && !processedParams.add(paramName)) {
                    ++problemCount;
                    this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_PARAM, tag, paramName);
                    continue;
                }
                IModelBuilder.IParameter parameter = method.getParameter(paramName);
                if (parameter != null) {
                    if (!pp.optional && st.hasMoreTokens() && st.nextToken().equals("optional")) {
                        pp.optional = true;
                    }
                    this.updateParameter(tag, parameter, pp, reporter, typeChecker);
                    continue;
                }
                ++problemCount;
                this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.UNKNOWN_PARAM, tag, paramName);
                continue;
            }
            ++problemCount;
            this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.MISSING_PARAMETER_NAME, tag, new Object[0]);
        }
        if (problemCount == 0 && reporter != null) {
            for (IModelBuilder.IParameter parameter : method.getParameters()) {
                if (processedParams.contains(parameter.getName()) || objectPropertiesTypes.containsKey(parameter.getName())) continue;
                ReferenceLocation location = parameter.getLocation();
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.PARAMETER_MISSING_ANNOTATION, JSDocProblem.PARAMETER_MISSING_ANNOTATION.formatMessage(parameter.getName()), location.getNameStart(), location.getNameEnd());
            }
        }
    }

    protected void updateParameter(JSDocTag tag, IModelBuilder.IParameter parameter, ParamInfo pp, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        if (pp.type != null && parameter.getType() == null) {
            JSType type = this.translateTypeName(pp.type, tag, reporter);
            if (typeChecker != null) {
                typeChecker.checkType(type, tag);
            }
            parameter.setType(type);
        }
        parameter.setOptional(pp.optional);
        parameter.setVarargs(pp.varargs);
    }

    public void parseType(IModelBuilder.IElement member, JSDocTags tags, String[] tagNames, JSProblemReporter reporter, IJSDocTypeChecker typeChecker) {
        JSDocTag tag = tags.get(tagNames);
        if (tag != null) {
            JSType type;
            int count;
            if (reporter != null && (count = tags.count(tagNames)) > 1) {
                for (JSDocTag t : tags.list(tagNames).subList(1, count)) {
                    if (t.name().equals(tag.name())) {
                        this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, t, t.name());
                        continue;
                    }
                    this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.DUPLICATE_TAG, String.valueOf(JSDocProblem.DUPLICATE_TAG.formatMessage(t.name())) + " (was " + tag.name() + ")", t);
                }
            }
            if ((type = this.parseType(tag, this.requireBraces(tag.name()), reporter)) != null) {
                if (typeChecker != null) {
                    typeChecker.checkType(type, tag);
                }
                member.setType(type);
            }
        }
    }

    public JSType parseType(JSDocTag tag, boolean requireBraces, JSProblemReporter reporter) {
        Tokenizer st = new Tokenizer(tag.value());
        if (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            if (!requireBraces || this.isBraced(typeName)) {
                return this.translateTypeName(this.cutBraces(typeName), tag, reporter);
            }
        } else if (!requireBraces) {
            this.reportProblem(reporter, (JSProblemIdentifier)JSDocProblem.MISSING_TYPE_NAME, tag, new Object[0]);
        }
        return null;
    }

    protected boolean requireBraces(String tagName) {
        return "@return".equals(tagName) || "@returns".equals(tagName);
    }

    private void reportProblem(JSProblemReporter reporter, JSProblemIdentifier problemIdentifier, JSDocTag tag, Object ... args) {
        if (reporter != null) {
            reporter.reportProblem((IProblemIdentifier)problemIdentifier, problemIdentifier.formatMessage(args), tag.start(), tag.end());
        }
    }

    private void reportProblem(JSProblemReporter reporter, JSProblemIdentifier problemIdentifier, String message, JSDocTag tag) {
        if (reporter != null) {
            reporter.reportProblem((IProblemIdentifier)problemIdentifier, message, tag.start(), tag.end());
        }
    }

    protected JSType translateTypeName(String typeName, JSDocTag tag, JSProblemReporter reporter) {
        JSDocTypeParser parser = this.createTypeParser();
        try {
            return parser.parse(typeName);
        }
        catch (ParseException e) {
            if (reporter != null) {
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_TYPE_SYNTAX, String.valueOf(e.getMessage()) + " after " + typeName.substring(0, e.getErrorOffset()), tag.start(), tag.end());
            }
            return null;
        }
    }

    protected JSDocTypeParser createTypeParser() {
        return new JSDocTypeParser();
    }

    protected String cutBraces(String typeName) {
        if (this.isBraced(typeName)) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        return typeName;
    }

    private boolean isBraced(String typeName) {
        int length = typeName.length();
        return length > 2 && typeName.charAt(0) == '{' && typeName.charAt(length - 1) == '}';
    }

    private void processSuppressWarnings(JSDocTag tag, JSProblemReporter reporter, IModelBuilder.IElement element) {
        boolean hasParenthesis;
        ANTLRStringStream input = new ANTLRStringStream(tag.value());
        boolean bl = hasParenthesis = input.LT(1) == 40;
        if (hasParenthesis) {
            input.consume();
        }
        int problemCount = reporter != null ? reporter.getProblemCount() : 0;
        while (true) {
            int ch;
            block16: {
                ch = input.LT(1);
                while (Character.isWhitespace(ch)) {
                    input.consume();
                    ch = input.LT(1);
                }
                if (ch == 34 || ch == 39) {
                    char quote = (char)ch;
                    input.consume();
                    int start = input.index();
                    while (true) {
                        if ((ch = input.LT(1)) == quote) {
                            this.suppressWarning(tag, reporter, element, (CharStream)input, start);
                            input.consume();
                            break block16;
                        }
                        if (ch == -1) {
                            if (reporter != null) {
                                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Closing " + quote + " expected", tag.start(), tag.end());
                            }
                            break block16;
                        }
                        input.consume();
                    }
                }
                int start = input.index();
                while (true) {
                    if ((ch = input.LT(1)) == 44 || ch == 41 || ch == -1 || Character.isWhitespace(ch)) {
                        this.suppressWarning(tag, reporter, element, (CharStream)input, start);
                        break;
                    }
                    input.consume();
                }
            }
            ch = input.LT(1);
            while (ch != -1 && Character.isWhitespace(ch)) {
                input.consume();
                ch = input.LT(1);
            }
            if (ch != 44) break;
            input.consume();
        }
        if (hasParenthesis) {
            if (input.LT(1) == 41) {
                input.consume();
            } else if (reporter != null) {
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Closing ) expected", tag.start(), tag.end());
            }
        }
        if (reporter != null && reporter.getProblemCount() == problemCount && input.LT(1) != -1) {
            reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "Unexpected content", tag.start(), tag.end());
        }
    }

    private void suppressWarning(JSDocTag tag, JSProblemReporter reporter, IModelBuilder.IElement element, CharStream input, int start) {
        String categoryId = input.substring(start, input.index() - 1);
        if (categoryId.length() != 0) {
            IProblemCategory category = this.getCategory(categoryId);
            if (category != null) {
                element.addSuppressedWarning(category);
            } else if (reporter != null) {
                reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, NLS.bind((String)"Unsupported {0}({1})", (Object)"@SuppressWarnings", (Object)categoryId), tag.start(), tag.end());
            }
        } else if (reporter != null) {
            reporter.reportProblem((IProblemIdentifier)JSDocProblem.WRONG_SUPPRESS_WARNING, "warning identifier expected", tag.start(), tag.end());
        }
    }

    protected IProblemCategory getCategory(String categoryId) {
        return ProblemCategoryManager.getInstance().getCategory("org.eclipse.dltk.javascript.core.nature", "@SuppressWarnings", categoryId);
    }

    protected static class ParamInfo {
        public String type;
        public boolean varargs;
        public boolean optional;

        protected ParamInfo() {
        }

        void clear() {
            this.type = null;
            this.varargs = false;
            this.optional = false;
        }
    }

    private static class Tokenizer {
        private final StringTokenizer st;
        private boolean hasCurrent = false;
        private String current;

        public Tokenizer(String content) {
            this.st = new StringTokenizer(content);
        }

        public boolean hasMoreTokens() {
            if (this.hasCurrent) {
                return true;
            }
            return this.st.hasMoreTokens();
        }

        public String peek() {
            if (!this.hasCurrent) {
                if (this.st.hasMoreElements()) {
                    this.hasCurrent = true;
                    this.current = this.getNextToken();
                } else {
                    return null;
                }
            }
            return this.current;
        }

        private String getNextToken() {
            String token = this.st.nextToken();
            while (!this.isClosed(token) && this.st.hasMoreTokens()) {
                token = String.valueOf(token) + this.st.nextToken();
            }
            return token;
        }

        private boolean isClosed(String str) {
            int open = 0;
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                if (ch == '{') {
                    ++open;
                } else if (ch == '}') {
                    --open;
                }
                ++i;
            }
            return open == 0;
        }

        public String nextToken() {
            if (this.hasCurrent) {
                this.hasCurrent = false;
                return this.current;
            }
            return this.getNextToken();
        }
    }
}

