/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ChildReference;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueCollection
implements IValueCollection,
IValueProvider {
    private final IValueCollection parent;
    private final IValue value;

    protected ValueCollection(IValueCollection parent) {
        this(parent, new Value());
    }

    protected ValueCollection(IValueCollection parent, IValue value) {
        this.parent = parent;
        this.value = value;
    }

    @Override
    public IValueCollection getParent() {
        return this.parent;
    }

    @Override
    public IValueReference getReturnValue() {
        return null;
    }

    @Override
    public IValueReference getThis() {
        return null;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public IValue getValue() {
        return this.value;
    }

    @Override
    public IValue createValue() {
        return this.getValue();
    }

    @Override
    public Set<String> getDirectChildren() {
        return this.value.getDirectChildren();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return this.value.getDeletedChildren();
    }

    @Override
    public boolean hasChild(String name) {
        IValue value = this.getValue();
        return value != null && value.getChild(name, true) != null;
    }

    @Override
    public IValueReference getChild(String name) {
        return this.newChild(name);
    }

    private ChildReference newChild(String name) {
        return new ChildReference(this, name);
    }

    @Override
    public IValueReference createChild(String name) {
        IValue childValue;
        IValueCollection coll = this;
        do {
            if (!(coll instanceof IValueProvider) || (childValue = ((IValueProvider)((Object)coll)).getValue().getChild(name, false)) == null) continue;
            if (coll != this) {
                this.getValue().putChild(name, childValue);
            }
            return this.newChild(name);
        } while ((coll = coll.getParent()) != null && !coll.isScope());
        coll = this;
        while (!coll.isScope()) {
            coll = coll.getParent();
        }
        childValue = this.getValue().createChild(name);
        if (coll != this) {
            this.getValue().putChild(name, childValue);
        }
        return this.newChild(name);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ITypeInferenceContext getContext() {
        return this.parent != null ? this.parent.getContext() : null;
    }
}

