/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.validation.FlowEndKind;
import org.eclipse.dltk.internal.javascript.validation.FlowScope;
import org.eclipse.dltk.internal.javascript.validation.FlowStatus;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowValidation
extends AbstractNavigationVisitor<FlowStatus>
implements IBuildParticipant {
    private Reporter reporter;
    private FlowScope scope;

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        this.reporter = JavaScriptValidations.createReporter(context);
        this.scope = new FlowScope();
        this.visit((ASTNode)script);
    }

    public FlowStatus visitReturnStatement(ReturnStatement node) {
        FlowEndKind kind;
        FlowEndKind flowEndKind = kind = node.getValue() != null ? FlowEndKind.RETURNS_VALUE : FlowEndKind.RETURNS;
        if (this.scope.add(kind) && this.scope.size() > 1) {
            this.reporter.setMessage((IProblemIdentifier)JavaScriptProblems.RETURN_INCONSISTENT, "return statement is inconsistent with previous usage");
            this.reporter.setRange(node.sourceStart(), node.sourceEnd());
            this.reporter.report();
        }
        FlowStatus status = new FlowStatus();
        if (node.getValue() == null) {
            status.returnWithoutValue = true;
        } else {
            status.returnValue = true;
        }
        return status;
    }

    public FlowStatus visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit((ASTNode)node.getException());
        }
        FlowStatus status = new FlowStatus();
        status.returnThrow = true;
        return status;
    }

    public FlowStatus visitStatementBlock(StatementBlock node) {
        FlowStatus status = new FlowStatus();
        status.noReturn = true;
        int startRange = Integer.MAX_VALUE;
        int endRange = -1;
        for (Statement statement : node.getStatements()) {
            if (status.isTerminatd()) {
                if (startRange > statement.sourceStart()) {
                    startRange = statement.sourceStart();
                }
                if (endRange >= statement.sourceEnd()) continue;
                endRange = statement.sourceEnd();
                continue;
            }
            status.add((FlowStatus)this.visit((ASTNode)statement));
        }
        if (startRange != Integer.MAX_VALUE) {
            this.reporter.setMessage((IProblemIdentifier)JavaScriptProblems.UNREACHABLE_CODE, "unreachable code");
            this.reporter.setRange(startRange, endRange);
            this.reporter.report();
        }
        return status;
    }

    public FlowStatus visitIfStatement(IfStatement node) {
        FlowStatus thenFlow;
        FlowStatus status = new FlowStatus();
        status.noReturn = true;
        if (node.getThenStatement() != null && (thenFlow = (FlowStatus)this.visit((ASTNode)node.getThenStatement())) != null) {
            status.noReturn = thenFlow.noReturn;
            status.returnValue = thenFlow.returnValue;
            status.returnWithoutValue = thenFlow.returnWithoutValue;
        }
        if (node.getElseStatement() != null) {
            FlowStatus elseFlow = (FlowStatus)this.visit((ASTNode)node.getElseStatement());
            if (elseFlow != null) {
                if (status.noReturn != elseFlow.noReturn) {
                    status.noReturn = true;
                }
                if (status.returnValue != elseFlow.returnValue) {
                    status.returnValue = true;
                }
                if (status.returnWithoutValue != elseFlow.returnWithoutValue) {
                    status.returnWithoutValue = true;
                }
            } else {
                status.noReturn = true;
            }
        } else {
            status.noReturn = true;
        }
        return status;
    }

    public FlowStatus visitFunctionStatement(FunctionStatement node) {
        FlowScope savedScope = this.scope;
        this.scope = new FlowScope();
        try {
            FlowStatus result = (FlowStatus)super.visitFunctionStatement(node);
            if (this.scope.contains((Object)FlowEndKind.RETURNS_VALUE) && (this.scope.contains((Object)FlowEndKind.RETURNS) || result.noReturn)) {
                this.reporter.setMessage((IProblemIdentifier)JavaScriptProblems.FUNCTION_NOT_ALWAYS_RETURN_VALUE, node.getName() != null ? NLS.bind((String)"function {0} does not always return a value", (Object)node.getName().getName()) : "anonymous function does not always return a value");
                this.reporter.setRange(node.getBody().getRC(), node.getBody().getRC() + 1);
                this.reporter.report();
            }
            FlowStatus flowStatus = result;
            return flowStatus;
        }
        finally {
            this.scope = savedScope;
        }
    }

    public FlowStatus visitBreakStatement(BreakStatement node) {
        FlowStatus status = new FlowStatus();
        status.isBreak = true;
        return status;
    }

    public FlowStatus visitContinueStatement(ContinueStatement node) {
        FlowStatus status = new FlowStatus();
        status.isBreak = true;
        return status;
    }

    public FlowStatus visitTryStatement(TryStatement node) {
        FlowStatus f;
        Statement finallyStatement;
        FlowStatus status = new FlowStatus();
        FlowStatus body = (FlowStatus)this.visit((ASTNode)node.getBody());
        status.add(body);
        if (!node.getCatches().isEmpty()) {
            status.returnThrow = false;
        }
        for (CatchClause catchClause : node.getCatches()) {
            Statement catchStatement = catchClause.getStatement();
            if (catchStatement == null) continue;
            this.visit((ASTNode)catchStatement);
        }
        if (node.getFinally() != null && (finallyStatement = node.getFinally().getStatement()) != null && (f = (FlowStatus)this.visit((ASTNode)finallyStatement)).isReturned()) {
            status.add(f);
        }
        return status;
    }

    public FlowStatus visitSwitchStatement(SwitchStatement node) {
        return (FlowStatus)super.visitSwitchStatement(node);
    }
}

