/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.formatter.FormatterIndentDetector;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.formatter.JavaScriptFormatterConstants;
import org.eclipse.dltk.javascript.formatter.internal.FormatterNodeBuilder;
import org.eclipse.dltk.javascript.formatter.internal.JavaScriptFormatterContext;
import org.eclipse.dltk.javascript.formatter.internal.JavaScriptFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.JavascriptFormatterNodeRewriter;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.JavaScriptParserProblems;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.dltk.ui.formatter.IScriptFormatterExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptFormatter
extends AbstractScriptFormatter
implements IScriptFormatterExtension {
    private final String lineDelimiter;
    private IProject project;

    public JavaScriptFormatter(String lineDelimiter, Map<String, ? extends Object> preferences) {
        super(preferences);
        this.lineDelimiter = lineDelimiter;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel) throws FormatterException {
        String formatted;
        String input = source.substring(offset, offset + length);
        if (!input.equals(formatted = this.format(input, indentationLevel))) {
            return new ReplaceEdit(offset, length, formatted);
        }
        return new MultiTextEdit();
    }

    private int detectIndentationLevel(String input, int offset) {
        ParserProblemReporter reporter = new ParserProblemReporter();
        Script ast = this.createParser().parse(input, (IProblemReporter)reporter);
        if (ast == null || reporter.hasErrors()) {
            if (DLTKCore.DEBUG) {
                System.out.println(reporter.getErrors());
            }
            return 0;
        }
        FormatterDocument fDocument = this.createDocument(input);
        FormatterNodeBuilder builder = new FormatterNodeBuilder((IFormatterDocument)fDocument);
        IFormatterContainerNode root = builder.build(ast);
        JavaScriptFormatterContext context = new JavaScriptFormatterContext(0);
        new JavascriptFormatterNodeRewriter(ast).rewrite(root);
        FormatterIndentDetector detector = new FormatterIndentDetector(offset);
        try {
            root.accept((IFormatterContext)context, (IFormatterWriter)detector);
            return detector.getLevel();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        if (offset == 0) {
            return 0;
        }
        return this.detectIndentationLevel(document.get(), offset);
    }

    public String format(String source, int indentationLevel) throws FormatterException {
        ParserProblemReporter reporter = new ParserProblemReporter();
        Script root = this.createParser().parse(source, (IProblemReporter)reporter);
        if (root == null || reporter.hasErrors()) {
            List errors = reporter.getErrors();
            if (!errors.isEmpty()) {
                if (errors.size() == 1 && errors.get(0) instanceof JSProblem) {
                    JSProblem problem = (JSProblem)errors.get(0);
                    throw new FormatterSyntaxProblemException(problem.getMessage(), problem.getCause());
                }
                IProblem first = null;
                for (IProblem problem : errors) {
                    if (!problem.isError() || problem instanceof JSProblem || problem.getSourceStart() < 0 || first != null && problem.getSourceStart() >= first.getSourceStart()) continue;
                    first = problem;
                }
                if (first != null) {
                    throw new FormatterSyntaxProblemException(first.getMessage());
                }
                StringBuilder sb = new StringBuilder();
                for (IProblem problem : errors) {
                    if (!problem.isError()) continue;
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(problem.getMessage());
                }
                throw new FormatterSyntaxProblemException(sb.toString());
            }
            throw new FormatterSyntaxProblemException("Syntax error");
        }
        return this.format(source, root, indentationLevel);
    }

    private String format(String source, Script ast, int indentationLevel) throws FormatterException {
        FormatterDocument document = this.createDocument(source);
        FormatterNodeBuilder builder = new FormatterNodeBuilder((IFormatterDocument)document);
        IFormatterContainerNode root = builder.build(ast);
        new JavascriptFormatterNodeRewriter(ast).rewrite(root);
        JavaScriptFormatterContext context = new JavaScriptFormatterContext(indentationLevel);
        JavaScriptFormatterWriter writer = new JavaScriptFormatterWriter((IFormatterDocument)document, this.lineDelimiter, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("wrap.comments.length"));
        writer.setLinesPreserve(1);
        writer.setPreserveSpaces(false);
        writer.setKeepLines(this.getBoolean("formatter.keep.lines"));
        try {
            root.accept((IFormatterContext)context, (IFormatterWriter)writer);
            writer.flush((IFormatterContext)context);
            return writer.getOutput();
        }
        catch (Exception e) {
            throw new FormatterException((Throwable)e);
        }
    }

    private FormatterDocument createDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        String[] options = JavaScriptFormatterConstants.getNames();
        int i = 0;
        while (i < options.length) {
            String name = options[i];
            if (JavaScriptFormatterConstants.isBoolean(name)) {
                document.setBoolean(name, this.getBoolean(name));
            } else if (JavaScriptFormatterConstants.isInteger(name)) {
                document.setInt(name, this.getInt(name));
            } else if (JavaScriptFormatterConstants.isString(name)) {
                document.setString(name, this.getString(name));
            }
            ++i;
        }
        return document;
    }

    public void initialize(IProject project) {
        this.project = project;
    }

    private JavaScriptParser createParser() {
        JavaScriptParser parser = new JavaScriptParser();
        return parser;
    }

    private static class ParserProblemReporter
    extends ProblemCollector {
        private ParserProblemReporter() {
        }

        public boolean hasErrors() {
            if (!this.problems.isEmpty()) {
                for (IProblem problem : this.problems) {
                    if (!problem.isError() || !this.isCritical(problem)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isCritical(IProblem problem) {
            return problem.getID() == JavaScriptParserProblems.LEXER_ERROR || problem.getID() == JavaScriptParserProblems.SYNTAX_ERROR || problem.getID() == JavaScriptParserProblems.INTERNAL_ERROR;
        }
    }
}

