/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.scriptdoc.ScriptDocumentationProvider;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.ui.documentation.DocumentationUtils;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;

public class JavaScriptProposalInfo
extends ProposalInfo {
    private final Object ref;

    public JavaScriptProposalInfo(Object ref) {
        super(null);
        this.ref = ref;
    }

    public String getInfo(IProgressMonitor monitor) {
        if (this.ref instanceof IReference) {
            Reader contentReader;
            ArrayList ms = new ArrayList();
            ((IReference)this.ref).addModelElements(ms);
            if (ms.size() > 0 && (contentReader = new ScriptDocumentationProvider().getInfo((IMember)ms.get(0), true, true)) != null) {
                String string = this.getString(contentReader);
                return string;
            }
        } else if (this.ref instanceof IMember) {
            Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)this.ref, true, true);
            if (contentReader != null) {
                String string = this.getString(contentReader);
                return string;
            }
        } else {
            if (this.ref instanceof String) {
                return (String)this.ref;
            }
            if (this.ref instanceof Element) {
                IDocumentationResponse response = ScriptDocumentationAccess.getDocumentation((String)"org.eclipse.dltk.javascript.core.nature", (Object)this.ref, null);
                if (response != null) {
                    try {
                        return this.getString(response.getReader());
                    }
                    catch (IOException e) {
                        JavaScriptUI.log(e);
                    }
                }
            } else if (this.ref instanceof IValueReference) {
                return this.getInfo((IValueReference)this.ref);
            }
        }
        return null;
    }

    private String getInfo(IValueReference ref) {
        block5: {
            final ReferenceLocation location = ref.getLocation();
            if (location == ReferenceLocation.UNKNOWN) {
                return null;
            }
            ISourceModule m = location.getSourceModule();
            if (m == null) {
                return null;
            }
            try {
                m.accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element instanceof IMember) {
                            try {
                                ISourceRange nameRange = ((IMember)element).getNameRange();
                                if (location.getNameStart() >= nameRange.getOffset() && location.getNameEnd() <= nameRange.getOffset() + nameRange.getLength()) {
                                    throw new ModelElementFound(element);
                                }
                            }
                            catch (ModelException e) {
                                e.printStackTrace();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            catch (ModelElementFound found) {
                Reader contentReader = new ScriptDocumentationProvider().getInfo((IMember)found.element, true, true);
                if (contentReader == null) break block5;
                return this.getString(contentReader);
            }
        }
        return null;
    }

    private String getString(Reader reader) {
        return DocumentationUtils.readAll((Reader)reader);
    }

    private static class ModelElementFound
    extends RuntimeException {
        final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }
}

