/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class CatchClause
extends JSNode
implements ISourceable {
    private Keyword catchKeyword;
    private Identifier exception;
    private Keyword ifKeyword = null;
    private Expression filterExpression = null;
    private Statement statement;
    private int LP = -1;
    private int RP = -1;

    public CatchClause(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.catchKeyword != null) {
                this.catchKeyword.traverse(visitor);
            }
            if (this.exception != null) {
                this.exception.traverse(visitor);
            }
            if (this.ifKeyword != null) {
                this.ifKeyword.traverse(visitor);
            }
            if (this.filterExpression != null) {
                this.filterExpression.traverse(visitor);
            }
            if (this.statement != null) {
                this.statement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Identifier getException() {
        return this.exception;
    }

    public void setException(Identifier exception) {
        this.exception = exception;
    }

    public Keyword getIfKeyword() {
        return this.ifKeyword;
    }

    public void setIfKeyword(Keyword ifKeyword) {
        this.ifKeyword = ifKeyword;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Keyword getCatchKeyword() {
        return this.catchKeyword;
    }

    public void setCatchKeyword(Keyword keyword) {
        this.catchKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("catch");
        buffer.append(" (");
        buffer.append(this.exception.toSourceString(indentationString));
        if (this.ifKeyword != null && this.filterExpression != null) {
            buffer.append(' ');
            buffer.append("if");
            buffer.append(' ');
            buffer.append(this.filterExpression.toSourceString(indentationString));
        }
        buffer.append(")\n");
        buffer.append(this.statement.toSourceString(indentationString));
        return buffer.toString();
    }
}

