/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptAnnotationIterator
implements Iterator<Annotation> {
    private Iterator<?> fIterator;
    private Annotation fNext;
    private boolean fSkipIrrelevants;
    private boolean fReturnAllAnnotations;

    public ScriptAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants) {
        this(model, skipIrrelevants, false);
    }

    public ScriptAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = model != null ? model.getAnnotationIterator() : Collections.EMPTY_LIST.iterator();
        this.fSkipIrrelevants = skipIrrelevants;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = (Annotation)this.fIterator.next();
            if (next instanceof IScriptAnnotation) {
                if (this.fSkipIrrelevants) {
                    if (next.isMarkedDeleted()) continue;
                    this.fNext = next;
                    return;
                }
                this.fNext = next;
                return;
            }
            if (!this.fReturnAllAnnotations) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    @Override
    public boolean hasNext() {
        return this.fNext != null;
    }

    @Override
    public Annotation next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

