/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.BrowserInformationControl;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.IInformationControlExtension4;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.ScriptHoverMessages;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationTitleAdapter;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class DocumentationHover
extends AbstractScriptEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private final long LABEL_FLAGS = 281474978857015L;
    private final long LOCAL_VARIABLE_FLAGS = 281474978988087L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private final IScriptDocumentationTitleAdapter titleAdapter = new IScriptDocumentationTitleAdapter(){

        public String getTitle(Object element) {
            if (element instanceof IModelElement) {
                IModelElement member = (IModelElement)element;
                long flags = member.getElementType() == 8 ? 281474978988087L : 281474978857015L;
                String label = ScriptElementLabels.getDefault().getElementLabel(member, flags);
                return label;
            }
            return null;
        }
    };

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, "org.eclipse.jface.dialogfont", true);
                    }
                    return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, "org.eclipse.jface.dialogfont", EditorsUI.getTooltipAffordanceString());
                    }
                    return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }

                public boolean canReuse(IInformationControl control) {
                    boolean canReuse = super.canReuse(control);
                    if (canReuse && control instanceof IInformationControlExtension4) {
                        ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
                    }
                    return canReuse;
                }
            };
        }
        return this.fHoverControlCreator;
    }

    protected String getHoverInfo(String nature, Object[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            HTMLPrinter.addSmallHeader(buffer, this.titleAdapter.getTitle(result[0]));
            HTMLPrinter.addParagraph(buffer, "<hr>");
            int i = 0;
            while (i < result.length) {
                Object element = result[i];
                Reader reader = ScriptDocumentationAccess.getHTMLContentReader(nature, element, true, true);
                if (reader != null) {
                    if (hasContents) {
                        HTMLPrinter.addParagraph(buffer, "<hr>");
                    }
                    HTMLPrinter.addParagraph(buffer, reader);
                    hasContents = true;
                }
                ++i;
            }
        } else {
            Object element = result[0];
            IDocumentationResponse response = ScriptDocumentationAccess.getDocumentation(nature, element, this.titleAdapter);
            if (response == null) {
                response = new TextDocumentationResponse(element, this.titleAdapter.getTitle(element), ScriptHoverMessages.ScriptdocHover_noAttachedInformation);
            }
            try {
                HTMLPrinter.addSmallHeader(buffer, response.getTitle());
                HTMLPrinter.addParagraph(buffer, response.getReader());
                hasContents = true;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, DocumentationHover.getStyleSheet());
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    protected String getHoverInfo(String nature, String content) {
        try {
            Reader reader = ScriptDocumentationAccess.getKeywordDocumentation(nature, (IModelElement)this.getEditorInputModelElement(), content);
            if (reader != null) {
                StringBuffer buffer = new StringBuffer();
                HTMLPrinter.addParagraph(buffer, reader);
                if (buffer.length() > 0) {
                    HTMLPrinter.insertPageProlog(buffer, 0, DocumentationHover.getStyleSheet());
                    HTMLPrinter.addPageEpilog(buffer);
                    return buffer.toString();
                }
            }
        }
        catch (ModelException modelException) {}
        return null;
    }
}

