/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.quickfix.CreateLocalVariableQuickFix;
import org.eclipse.dltk.javascript.internal.ui.quickfix.TextFileEditResolution;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateTopLevelVariable
extends TextFileEditResolution {
    public CreateTopLevelVariable(IFile scriptFile, int problemStartIdx) {
        super(scriptFile, problemStartIdx);
    }

    public String getLabel() {
        return "Creates a top level variable in the file";
    }

    public Image getImage() {
        return DLTKPluginImages.getImage((AbstractUIPlugin)JavaScriptUI.getDefault(), (String)"icons/obj16/field_public_obj.gif");
    }

    public String getDescription() {
        Identifier identifier = CreateLocalVariableQuickFix.getIdentifier(this.getScriptFile(), this.getProblemStartIdx());
        if (identifier != null) {
            ASTNode parent = identifier.getParent();
            while (parent instanceof JSNode) {
                if (parent instanceof FunctionStatement) {
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.getScriptFile());
                    try {
                        Comment documentation;
                        String functionString = sourceModule.getBuffer().getText(parent.sourceStart(), identifier.sourceEnd() - parent.sourceStart());
                        int index = functionString.indexOf(10);
                        if (index != -1) {
                            functionString.substring(0, index);
                        }
                        if ((documentation = ((FunctionStatement)parent).getDocumentation()) != null) {
                            functionString = String.valueOf(documentation.getText()) + "<br>" + functionString;
                        }
                        StringBuilder sb = new StringBuilder(functionString.length() + 50);
                        sb.append("<html><body>");
                        sb.append("<b>var ");
                        sb.append(identifier.getName());
                        sb.append(";</b><br><br>");
                        sb.append(functionString.replace("\n", "<br>"));
                        sb.append("</body></html>");
                        return sb.toString();
                    }
                    catch (ModelException modelException) {
                        break;
                    }
                }
                parent = ((JSNode)parent).getParent();
            }
            return "<html><body>Create top level/file variable<br><b>var </b>" + identifier.getName() + "<body></html>";
        }
        return "Failed to create a local variable";
    }

    protected MultiTextEdit getTextEdit(IFile file, int offset) {
        MultiTextEdit edit = new MultiTextEdit();
        Identifier identifier = CreateLocalVariableQuickFix.getIdentifier(this.getScriptFile(), this.getProblemStartIdx());
        if (identifier != null) {
            JSNode topLevel = null;
            ASTNode parent = identifier.getParent();
            while (parent instanceof JSNode) {
                if (!(parent instanceof Script)) {
                    topLevel = (JSNode)parent;
                }
                parent = ((JSNode)parent).getParent();
            }
            if (topLevel != null) {
                int startindex = -1;
                startindex = topLevel.getDocumentation() != null ? topLevel.getDocumentation().getRange().getOffset() : topLevel.sourceStart();
                edit.addChild((TextEdit)new InsertEdit(startindex, "var " + identifier.getName() + ";\n\n"));
            }
        }
        return edit;
    }

    public boolean isValid() {
        Identifier identifier = CreateLocalVariableQuickFix.getIdentifier(this.getScriptFile(), this.getProblemStartIdx());
        if (identifier != null) {
            ASTNode parent = identifier.getParent();
            while (parent instanceof JSNode) {
                if (parent instanceof FunctionStatement) {
                    return true;
                }
                parent = ((JSNode)parent).getParent();
            }
        }
        return false;
    }
}

