/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;

public class NodeFinder
extends ASTVisitor {
    final int start;
    final int end;
    ASTNode before = null;
    ASTNode after = null;

    public NodeFinder(int position) {
        this(position, position);
    }

    public NodeFinder(int s, int e) {
        this.start = s;
        this.end = e;
    }

    @Deprecated
    public NodeFinder(String content, int s, int e) {
        this.start = s;
        this.end = e;
    }

    private static boolean isBlock(ASTNode node) {
        return node instanceof Script || node instanceof FunctionStatement || node instanceof Statement;
    }

    public boolean visit(ASTNode node) {
        if (NodeFinder.isBlock(node)) {
            if (node.sourceEnd() < this.start || node.sourceStart() > this.end) {
                return false;
            }
            return node.sourceEnd() != this.start || !(node instanceof ISemicolonStatement) || ((ISemicolonStatement)node).getSemicolonPosition() < 0;
        }
        boolean enter = false;
        if (this.before == null || NodeFinder.isCloser(node, this.before, this.start)) {
            this.before = node;
            enter = true;
        }
        if (this.after == null || NodeFinder.isCloser(node, this.after, this.end)) {
            this.after = node;
            enter = true;
        }
        return enter;
    }

    private static boolean isCloser(ASTNode node, ASTNode result, int pos) {
        return node.sourceStart() >= result.sourceStart() && node.sourceStart() <= pos;
    }

    private boolean traverse(Script script) {
        this.after = null;
        this.before = null;
        try {
            script.traverse((ASTVisitor)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public NodeFinder locate(Script script) {
        if (!this.traverse(script)) {
            this.before = null;
            this.after = null;
        }
        return this;
    }

    public ASTNode getNode() {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        if (this.isValid(this.before)) {
            nodes.add(this.before);
        }
        if (this.isValid(this.after)) {
            nodes.add(this.after);
        }
        if (!nodes.isEmpty()) {
            if (nodes.size() > 1) {
                Collections.sort(nodes, new Comparator<ASTNode>(){

                    @Override
                    public int compare(ASTNode o1, ASTNode o2) {
                        int distance1 = this.distanceTo(o1);
                        int distance2 = this.distanceTo(o2);
                        return Math.abs(distance1) - Math.abs(distance2);
                    }

                    private int distanceTo(ASTNode o1) {
                        if (o1.sourceStart() >= NodeFinder.this.start && o1.sourceStart() <= NodeFinder.this.end || o1.sourceEnd() >= NodeFinder.this.start && o1.sourceEnd() <= NodeFinder.this.end) {
                            return 0;
                        }
                        return (o1.sourceEnd() + o1.sourceStart() - (NodeFinder.this.start + NodeFinder.this.end)) / 2;
                    }
                });
            }
            return (ASTNode)nodes.get(0);
        }
        return null;
    }

    private boolean isValid(ASTNode n) {
        return n != null && n.sourceStart() <= this.end && n.sourceEnd() >= this.start;
    }
}

