/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionPath;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.core.codeassist.CompletionVisitor;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.core.codeassist.NodeFinder;
import org.eclipse.dltk.javascript.internal.core.codeassist.PositionCalculator;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueParent;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.TypeMemberQuery;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

public class JavaScriptCompletionEngine2
extends ScriptCompletionEngine
implements JSCompletionEngine {
    private boolean useEngine = true;

    public boolean isUseEngine() {
        return this.useEngine;
    }

    public void setUseEngine(boolean useEngine) {
        this.useEngine = useEngine;
    }

    public void complete(IModuleSource cu, int position, int i) {
        this.requestor.beginReporting();
        String content = cu.getSourceContents();
        if (position < 0 || position > content.length()) {
            return;
        }
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement(cu.getModelElement());
        Script script = JavaScriptParserUtil.parse((IModuleSource)cu, null);
        NodeFinder nodeFinder = new NodeFinder(position, position);
        nodeFinder.locate(script);
        if (nodeFinder.getNode() instanceof StringLiteral) {
            return;
        }
        PositionCalculator calculator = new PositionCalculator(content, position, false);
        CompletionVisitor visitor = new CompletionVisitor(inferencer2, position);
        inferencer2.setVisitor(visitor);
        if (cu instanceof ISourceModule) {
            inferencer2.setModelElement((IModelElement)((ISourceModule)cu));
        }
        try {
            inferencer2.doInferencing(script);
        }
        catch (PositionReachedException positionReachedException) {}
        CompletionPath path = new CompletionPath(calculator.getCompletion());
        Reporter reporter = new Reporter(path.lastSegment(), position);
        if (calculator.isMember() && !path.isEmpty() && path.lastSegment() != null) {
            this.doCompletionOnMember(inferencer2, visitor.getCollection(), path, reporter);
        } else {
            this.doGlobalCompletion(inferencer2, visitor.getCollection(), reporter);
        }
        this.requestor.endReporting();
    }

    public void completeTypes(ISourceModule module, TypeMode mode, String prefix, int offset) {
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement((IModelElement)module);
        this.doCompletionOnType(inferencer2, mode, new Reporter(prefix, offset));
    }

    private void doCompletionOnType(ITypeInferenceContext context, TypeMode mode, Reporter reporter) {
        Set<String> typeNames = context.listTypes(mode, reporter.getPrefix());
        for (String typeName : typeNames) {
            Type type = context.getType(typeName);
            if (type == null || !type.isVisible()) continue;
            reporter.reportTypeRef(type);
        }
    }

    private static boolean exists(IValueParent item) {
        if (item instanceof IValueReference) {
            return ((IValueReference)item).exists();
        }
        return true;
    }

    private void doCompletionOnMember(ITypeInferenceContext context, IValueCollection collection, CompletionPath path, Reporter reporter) {
        IValueParent item = collection;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            if (path.isName(i)) {
                String segment = path.segment(i);
                item = "this".equals(segment) && item instanceof IValueCollection ? ((IValueCollection)item).getThis() : item.getChild(segment);
                if (!JavaScriptCompletionEngine2.exists(item)) {
                    break;
                }
            } else if (path.isFunction(i)) {
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("()"))) {
                    break;
                }
            } else {
                if (path.isObject(i)) {
                    item = item.getChild("Object").getChild("()");
                    break;
                }
                assert (path.isArray(i));
                if (!JavaScriptCompletionEngine2.exists(item = item.getChild("[]"))) break;
            }
            ++i;
        }
        if (item != null && JavaScriptCompletionEngine2.exists(item)) {
            this.reportItems(context, reporter, item, true);
        }
    }

    protected void reportItems(ITypeInferenceContext context, Reporter reporter, IValueParent item, boolean testPrivate) {
        reporter.report(context, item, testPrivate);
        if (item instanceof IValueCollection) {
            IValueCollection coll = (IValueCollection)item;
            while ((coll = coll.getParent()) != null) {
                reporter.report(context, coll, testPrivate);
            }
        } else if (item instanceof IValueReference) {
            reporter.reportValueTypeMembers(context, (IValueReference)item);
        }
    }

    protected void reportGlobals(ITypeInferenceContext context, Reporter reporter) {
        Set<String> globals = context.listGlobals(reporter.getPrefix());
        for (String global : globals) {
            Type type;
            if (reporter.canReport(global)) {
                Member element = context.resolve(global);
                if (element == null || !element.isVisible()) continue;
                reporter.report(global, element);
                continue;
            }
            if (global.lastIndexOf(46) == -1 || (type = context.getType(global)) == null || !type.isVisible() || type.getKind() == TypeKind.UNKNOWN) continue;
            reporter.reportTypeRef(type);
        }
    }

    private void doGlobalCompletion(ITypeInferenceContext context, IValueCollection collection, Reporter reporter) {
        this.reportItems(context, reporter, collection, false);
        if (this.useEngine) {
            this.doCompletionOnType(context, TypeMode.CODE, reporter);
            this.doCompletionOnKeyword(reporter.getPrefix(), reporter.getPosition());
            this.reportGlobals(context, reporter);
        }
    }

    private void doCompletionOnKeyword(String startPart, int position) {
        this.setSourceRange(position - startPart.length(), position);
        String[] keywords = JavaScriptKeywords.getJavaScriptKeywords();
        this.findKeywords(startPart.toCharArray(), keywords, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reporter {
        final char[] prefix;
        private final String prefixStr;
        final int position;
        final Set<String> processed = new HashSet<String>();
        final boolean camelCase = "enabled".equals(DLTKCore.getOption((String)"org.eclipse.dltk.core.codeComplete.camelCaseMatch"));

        public Reporter(String prefix, int position) {
            this.prefixStr = prefix != null ? prefix : "";
            this.prefix = this.prefixStr.toCharArray();
            this.position = position;
            JavaScriptCompletionEngine2.this.setSourceRange(position - this.prefix.length, position);
        }

        public void ignore(String generatedIdentifier) {
            this.processed.add(generatedIdentifier);
        }

        public String getPrefix() {
            return this.prefixStr;
        }

        public int getPosition() {
            return this.position;
        }

        public void report(String name, Element element) {
            if (element instanceof Member && this.processed.add(name)) {
                this.reportMember((Member)element, name, false);
            }
        }

        public boolean canReport(String name) {
            return this.matches(name) && !this.processed.contains(name);
        }

        private boolean matches(String name) {
            return CharOperation.prefixEquals((char[])this.prefix, (String)name, (boolean)false) || this.camelCase && CharOperation.camelCaseMatch((char[])this.prefix, (char[])name.toCharArray());
        }

        public void report(ITypeInferenceContext context, IValueParent item, boolean testPrivate) {
            boolean superScope = false;
            if (item instanceof IValueProvider) {
                superScope = ((IValueProvider)((Object)item)).getValue().getAttribute("SUPER_SCOPE", false) == Boolean.TRUE;
            }
            Set<String> deleted = item.getDeletedChildren();
            for (String childName : item.getDirectChildren()) {
                IValueReference child;
                if (childName.equals("()") || deleted.contains(childName) || !this.matches(childName) || !this.processed.add(childName) || !(child = item.getChild(childName)).exists()) continue;
                if (testPrivate) {
                    IRMethod method = (IRMethod)child.getAttribute("R_METHOD");
                    IRVariable variable = (IRVariable)child.getAttribute("R_VARIABLE");
                    if (method != null && (method.isPrivate() || method.isProtected() && !superScope) || variable != null && (variable.isPrivate() || variable.isProtected() && !superScope)) {
                        continue;
                    }
                } else if (child.getAttribute("PRIVATE") == Boolean.TRUE) continue;
                this.reportReference(child);
            }
        }

        public void reportValueTypeMembers(ITypeInferenceContext context, IValueReference valueRef) {
            TypeMemberQuery typeQuery = new TypeMemberQuery();
            ArrayList<Member> members = new ArrayList<Member>();
            this.collectTypes(context, valueRef.getDeclaredTypes(), typeQuery, members);
            this.collectTypes(context, valueRef.getTypes(), typeQuery, members);
            for (Member member : members) {
                this.reportMember(member, member.getName(), true);
            }
            for (Member member : typeQuery.ignoreDuplicates(this.processed)) {
                if (!member.isVisible() || !CharOperation.prefixEquals((char[])this.prefix, (String)member.getName(), (boolean)false)) continue;
                this.reportMember(member, member.getName(), typeQuery.contains(member.getDeclaringType()));
            }
        }

        protected void collectTypes(ITypeInferenceContext context, JSTypeSet types, TypeMemberQuery typeQuery, List<Member> members) {
            for (IRType type : types) {
                Type t;
                if (type instanceof IRClassType) {
                    t = ((IRClassType)type).getTarget();
                    if (t == null) continue;
                    typeQuery.add(t, t.memberPredicateFor(type, MemberPredicate.STATIC));
                    continue;
                }
                if (type instanceof IRSimpleType) {
                    t = ((IRSimpleType)type).getTarget();
                    if (t == null) continue;
                    typeQuery.add(t, t.memberPredicateFor(type, MemberPredicate.NON_STATIC));
                    continue;
                }
                if (type instanceof IRRecordType) {
                    for (IRRecordMember member : ((IRRecordType)type).getMembers()) {
                        members.add(member.getMember());
                    }
                    continue;
                }
                t = TypeUtil.extractType(context, type);
                if (t == null) continue;
                typeQuery.add(t, MemberPredicate.NON_STATIC);
            }
        }

        private void reportMember(Member member, String memberName, boolean important) {
            Method method;
            int paramCount;
            boolean isFunction = member instanceof Method;
            CompletionProposal proposal = CompletionProposal.create((int)(isFunction ? 5 : 1), (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, memberName);
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(memberName);
            proposal.setName(memberName);
            proposal.setExtraInfo((Object)member);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            if (isFunction && (paramCount = (method = (Method)member).getParameters().size()) > 0) {
                String[] params = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    Parameter parameter = (Parameter)method.getParameters().get(i);
                    params[i] = parameter.getKind() == ParameterKind.OPTIONAL ? String.valueOf('[') + parameter.getName() + ']' : parameter.getName();
                    ++i;
                }
                proposal.setParameterNames(params);
            }
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }

        private void reportReference(IValueReference reference) {
            int paramCount;
            IRMethod method;
            int proposalKind = 1;
            ReferenceKind kind = reference.getKind();
            if (reference.getAttribute("PHANTOM", true) == null && (kind == ReferenceKind.FUNCTION || reference.hasChild("()"))) {
                proposalKind = 5;
            } else if (kind == ReferenceKind.LOCAL) {
                proposalKind = 4;
            }
            CompletionProposal proposal = CompletionProposal.create((int)proposalKind, (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, reference.getName());
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(reference.getName());
            proposal.setName(reference.getName());
            proposal.setExtraInfo((Object)reference);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            if (proposalKind == 5 && (method = (IRMethod)reference.getAttribute("R_METHOD", true)) != null && (paramCount = method.getParameterCount()) > 0) {
                String[] params = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    IRParameter parameter = method.getParameters().get(i);
                    params[i] = parameter.isOptional() ? String.valueOf('[') + parameter.getName() + ']' : parameter.getName();
                    ++i;
                }
                proposal.setParameterNames(params);
            }
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }

        public void reportTypeRef(Type type) {
            if (!this.processed.add(type.getName())) {
                return;
            }
            CompletionProposal proposal = CompletionProposal.create((int)7, (int)this.position);
            int relevance = JavaScriptCompletionEngine2.this.computeBaseRelevance();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForInterestingProposal();
            relevance += JavaScriptCompletionEngine2.this.computeRelevanceForCaseMatching(this.prefix, type.getName());
            proposal.setRelevance(relevance += JavaScriptCompletionEngine2.this.computeRelevanceForRestrictions(0));
            proposal.setCompletion(type.getName());
            proposal.setName(type.getName());
            proposal.setExtraInfo((Object)type);
            proposal.setReplaceRange(JavaScriptCompletionEngine2.this.startPosition - JavaScriptCompletionEngine2.this.offset, JavaScriptCompletionEngine2.this.endPosition - JavaScriptCompletionEngine2.this.offset);
            JavaScriptCompletionEngine2.this.requestor.accept(proposal);
        }
    }
}

