/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.console;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.util.Util;

public class RubyConsoleSourceModuleLookup {
    private final IDLTKSearchScope scope;

    public RubyConsoleSourceModuleLookup(IDLTKLanguageToolkit toolkit) {
        this.scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
    }

    private IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    private boolean checkScope(IProject project, IPath[] scopeProjectsAndZips) {
        IPath location = project.getFullPath();
        int j = 0;
        while (j < scopeProjectsAndZips.length) {
            if (scopeProjectsAndZips[j].equals((Object)location)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public ISourceModule findSourceModuleByLocalPath(IPath path) {
        boolean isFullPath = EnvironmentPathUtils.isFull((IPath)path);
        IProject[] projects = this.getAllProjects();
        IPath[] enclosingProjectsAndZips = this.scope.enclosingProjectsAndZips();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IScriptProject scriptProject;
                ISourceModule module;
                IProject project = projects[i];
                if (this.checkScope(project, enclosingProjectsAndZips) && project.isAccessible() && DLTKLanguageManager.hasScriptNature((IProject)project) && (module = this.findInProject(scriptProject = DLTKCore.create((IProject)project), path, isFullPath)) != null) {
                    return module.exists() ? module : null;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    public static boolean isIncluded(IProjectFragment fragment, IPath path) {
        IProjectFragment root = fragment;
        return !Util.isExcluded((IPath)path, (IProjectFragment)root, (boolean)false);
    }

    private ISourceModule findInProject(IScriptProject scriptProject, IPath path, boolean isFullPath) throws ModelException {
        IProjectFragment[] roots = scriptProject.getProjectFragments();
        int j = 0;
        int rootCount = roots.length;
        while (j < rootCount) {
            IPath localPath;
            IProjectFragment root = roots[j];
            IPath rootPath = root.getPath();
            if (!isFullPath) {
                rootPath = EnvironmentPathUtils.getLocalPath((IPath)rootPath);
            }
            if (rootPath.isPrefixOf(path) && RubyConsoleSourceModuleLookup.isIncluded(root, path) && (localPath = path.setDevice(null).removeFirstSegments(rootPath.segmentCount())).segmentCount() >= 1) {
                IScriptFolder folder = localPath.segmentCount() > 1 ? root.getScriptFolder(localPath.removeLastSegments(1)) : root.getScriptFolder((IPath)Path.EMPTY);
                return folder.getSourceModule(localPath.lastSegment());
            }
            ++j;
        }
        return null;
    }
}

