/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSTypeSet
implements Iterable<IRType> {
    private static final JSEmptyTypeSet EMPTY_SET = new JSEmptyTypeSet();

    public static JSTypeSet emptySet() {
        return EMPTY_SET;
    }

    public static JSTypeSet singleton(IRType type) {
        if (type instanceof IRUnionType) {
            JSTypeSet set = JSTypeSet.create();
            set.add(type);
            return set;
        }
        return new JSSingletonTypeSet(type);
    }

    public static IRType normalize(ITypeSystem context, JSType type) {
        return RTypes.create(context, type);
    }

    public static IRType any() {
        return RTypes.any();
    }

    public static IRType none() {
        return RTypes.none();
    }

    public static IRType undefined() {
        return RTypes.undefined();
    }

    public static JSTypeSet create() {
        return new JSTypeSetImpl();
    }

    public static JSTypeSet create(IRType type) {
        if (type == null || type == RTypes.none()) {
            return JSTypeSet.emptySet();
        }
        JSTypeSetImpl set = new JSTypeSetImpl();
        ((JSTypeSet)set).add(type);
        return set;
    }

    public static JSTypeSet of(Iterable<? extends IRType> argTypes) {
        if (argTypes instanceof JSTypeSet) {
            return (JSTypeSet)argTypes;
        }
        Iterator<? extends IRType> i = argTypes.iterator();
        if (i.hasNext()) {
            JSTypeSet result = JSTypeSet.create();
            do {
                result.add(i.next());
            } while (i.hasNext());
            return result;
        }
        return JSTypeSet.emptySet();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSTypeSet) {
            JSTypeSet other = (JSTypeSet)obj;
            return this.size() == other.size() && this.containsAll(other);
        }
        return false;
    }

    public abstract void add(IRType var1);

    @Deprecated
    public abstract IRType getFirst();

    public abstract IRType toRType();

    @Deprecated
    public abstract Type[] toArray();

    public abstract int size();

    public abstract void addAll(Iterable<IRType> var1);

    public abstract boolean isEmpty();

    public abstract void clear();

    public abstract boolean contains(IRType var1);

    public abstract boolean containsAll(JSTypeSet var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<IRType> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IRType next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSEmptyTypeSet
    extends JSTypeSet {
        protected JSEmptyTypeSet() {
        }

        @Override
        public Iterator<IRType> iterator() {
            return new EmptyIterator();
        }

        @Override
        public void add(IRType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRType getFirst() {
            return null;
        }

        @Override
        public IRType toRType() {
            return null;
        }

        @Override
        public Type[] toArray() {
            return new Type[0];
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void addAll(Iterable<IRType> types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(IRType type) {
            return false;
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSSingletonTypeSet
    extends JSTypeSet {
        private final IRType type;

        public JSSingletonTypeSet(IRType type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public Iterator<IRType> iterator() {
            return new SingletonIterator(this.type);
        }

        @Override
        public void add(IRType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRType getFirst() {
            return this.type;
        }

        @Override
        public IRType toRType() {
            return this.type;
        }

        @Override
        public Type[] toArray() {
            if (this.type instanceof IRSimpleType) {
                return new Type[]{((IRSimpleType)this.type).getTarget()};
            }
            if (this.type instanceof IRClassType) {
                return new Type[]{((IRClassType)this.type).getTarget()};
            }
            if (this.type == RTypes.any()) {
                return new Type[]{Types.OBJECT};
            }
            return new Type[0];
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void addAll(Iterable<IRType> types) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(IRType type) {
            return this.type.equals(type);
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            return types.isEmpty() || types.size() == 1 && this.contains(types.toRType());
        }

        public String toString() {
            return "[" + this.type + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JSTypeSetImpl
    extends JSTypeSet {
        private final List<IRType> types = new ArrayList<IRType>(3);

        protected JSTypeSetImpl() {
        }

        @Override
        public Iterator<IRType> iterator() {
            return this.types.iterator();
        }

        @Override
        public void add(IRType type) {
            assert (type != null);
            if (type instanceof IRUnionType) {
                for (IRType t : ((IRUnionType)type).getTargets()) {
                    this.add(t);
                }
            } else if (!this.types.contains(type)) {
                this.types.add(type);
            }
        }

        @Override
        public IRType getFirst() {
            return this.types.get(0);
        }

        @Override
        public IRType toRType() {
            if (this.types.isEmpty()) {
                return null;
            }
            if (this.types.size() == 1) {
                return this.types.get(0);
            }
            return RTypes.union(this.types);
        }

        @Override
        public Type[] toArray() {
            LinkedHashSet<Type> result = new LinkedHashSet<Type>();
            for (IRType type : this.types) {
                if (type instanceof IRSimpleType) {
                    result.add(((IRSimpleType)type).getTarget());
                    continue;
                }
                if (type != RTypes.any()) continue;
                result.add(Types.OBJECT);
            }
            return result.toArray(new Type[result.size()]);
        }

        @Override
        public int size() {
            return this.types.size();
        }

        @Override
        public void addAll(Iterable<IRType> types) {
            for (IRType type : types) {
                this.add(type);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.types.isEmpty();
        }

        @Override
        public void clear() {
            this.types.clear();
        }

        @Override
        public boolean contains(IRType type) {
            return this.types.contains(type);
        }

        @Override
        public boolean containsAll(JSTypeSet types) {
            for (IRType type : types) {
                if (this.contains(type)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.types.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<IRType> {
        private final IRType type;
        private boolean hasNext = true;

        public SingletonIterator(IRType type) {
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public IRType next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.type;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

